/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import org.slf4j.Logger;

public class ProgressLogger {
    private final Logger log;
    private final long tickPoint;
    private final int superTick;
    private final Timer timer;
    private final String label;
    private long counterBatch = 0L;
    private long counterTotal = 0L;
    private long lastTime = 0L;

    public ProgressLogger(Logger log, String label, long tickPoint, int superTick) {
        this.log = log;
        this.label = label;
        this.tickPoint = tickPoint;
        this.superTick = superTick;
        this.timer = new Timer();
    }

    public void start() {
        this.timer.startTimer();
        this.lastTime = 0L;
    }

    public long finish() {
        long totalTime = this.timer.endTimer();
        return totalTime;
    }

    public long getTicks() {
        return this.counterTotal;
    }

    public void tick() {
        ++this.counterBatch;
        ++this.counterTotal;
        if (ProgressLogger.tickPoint(this.counterTotal, this.tickPoint)) {
            long timePoint = this.timer.readTimer();
            long thisTime = timePoint - this.lastTime;
            long batchAvgRate = this.counterBatch * 1000L / thisTime;
            long runAvgRate = this.counterTotal * 1000L / timePoint;
            this.print("Add: %,d %s (Batch: %,d / Avg: %,d)", this.counterTotal, this.label, batchAvgRate, runAvgRate);
            this.lastTime = timePoint;
            if (ProgressLogger.tickPoint(this.counterTotal, (long)this.superTick * this.tickPoint)) {
                this.elapsed(timePoint);
            }
            this.counterBatch = 0L;
            this.lastTime = timePoint;
        }
    }

    private void elapsed(long timerReading) {
        float elapsedSecs = (float)timerReading / 1000.0f;
        this.print("  Elapsed: %,.2f seconds [%s]", Float.valueOf(elapsedSecs), Utils.nowAsString());
    }

    private void print(String fmt, Object ... args) {
        if (this.log != null && this.log.isInfoEnabled()) {
            String str2 = String.format(fmt, args);
            this.log.info(str2);
        }
    }

    static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }
}

