/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    static Logger log = LoggerFactory.getLogger(LocationMapper.class);
    Map<String, String> altLocations = new HashMap<String, String>();
    Map<String, String> altPrefixes = new HashMap<String, String>();

    public LocationMapper() {
    }

    public LocationMapper(LocationMapper locMapper) {
        this.altLocations.putAll(locMapper.altLocations);
        this.altPrefixes.putAll(locMapper.altPrefixes);
    }

    public void copyFrom(LocationMapper lmap2) {
        this.altLocations.putAll(lmap2.altLocations);
        this.altPrefixes.putAll(lmap2.altPrefixes);
    }

    public String altMapping(String uri) {
        return this.altMapping(uri, uri);
    }

    public String altMapping(String uri, String otherwise) {
        if (this.altLocations.containsKey(uri)) {
            return this.altLocations.get(uri);
        }
        String newStart = null;
        String oldStart = null;
        for (String prefix : this.altPrefixes.keySet()) {
            if (!uri.startsWith(prefix)) continue;
            String s = this.altPrefixes.get(prefix);
            if (newStart != null && newStart.length() >= s.length()) continue;
            oldStart = prefix;
            newStart = s;
        }
        if (newStart != null) {
            return newStart + uri.substring(oldStart.length());
        }
        return otherwise;
    }

    public void addAltEntry(String uri, String alt2) {
        this.altLocations.put(uri, alt2);
    }

    public void addAltPrefix(String uriPrefix, String altPrefix) {
        this.altPrefixes.put(uriPrefix, altPrefix);
    }

    public Iterator<String> listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator<String> listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String uri) {
        this.altLocations.remove(uri);
    }

    public void removeAltPrefix(String uriPrefix) {
        this.altPrefixes.remove(uriPrefix);
    }

    public String getAltEntry(String uri) {
        return this.altLocations.get(uri);
    }

    public String getAltPrefix(String uriPrefix) {
        return this.altPrefixes.get(uriPrefix);
    }

    public int hashCode() {
        int x = 0;
        x ^= this.altLocations.hashCode();
        return x ^= this.altPrefixes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocationMapper)) {
            return false;
        }
        LocationMapper other = (LocationMapper)obj;
        if (!this.altLocations.equals(other.altLocations)) {
            return false;
        }
        return this.altPrefixes.equals(other.altPrefixes);
    }

    public String toString() {
        String v;
        String s = "";
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            s = s + "(Loc:" + k + "=>" + v + ") ";
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            s = s + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s;
    }

    public Model toModel() {
        Model m = ModelFactory.createDefaultModel();
        m.setNsPrefix("lmap", "http://jena.hpl.hp.com/2004/08/location-mapping#");
        this.toModel(m);
        return m;
    }

    public void toModel(Model model) {
        String v;
        String k;
        Resource e2;
        Resource r;
        Iterator<String> iter = this.altLocations.keySet().iterator();
        while (iter.hasNext()) {
            r = model.createResource();
            e2 = model.createResource();
            model.add(r, LocationMappingVocab.mapping, (RDFNode)e2);
            k = iter.next();
            v = this.altLocations.get(k);
            model.add(e2, LocationMappingVocab.name, k);
            model.add(e2, LocationMappingVocab.altName, v);
        }
        iter = this.altPrefixes.keySet().iterator();
        while (iter.hasNext()) {
            r = model.createResource();
            e2 = model.createResource();
            model.add(r, LocationMappingVocab.mapping, (RDFNode)e2);
            k = iter.next();
            v = this.altPrefixes.get(k);
            model.add(e2, LocationMappingVocab.prefix, k);
            model.add(e2, LocationMappingVocab.altPrefix, v);
        }
    }
}

