/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.ArgvUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import rreval.ClientMessageHandler;
import rreval.Verbose;

public class RReClientApp {
    public static final int CLIENT_PORT_RJ_DEFAULT = 4460;
    int portRJ;
    boolean keepRunning;
    ServerSocket serverSocket;
    String[] argv;
    List<ClientMessageHandler> clientHandlers;

    public RReClientApp(int portRJ, String[] argv) {
        this.portRJ = portRJ;
        this.argv = argv;
        this.clientHandlers = new ArrayList<ClientMessageHandler>();
    }

    protected RReClientApp() {
    }

    public void launch() {
        try {
            this.keepRunning = true;
            this.serverSocket = new ServerSocket(this.portRJ);
            Verbose.show("... waiting for rre client to connect on port " + this.portRJ);
            while (this.keepRunning) {
                try {
                    Socket s = this.serverSocket.accept();
                    ClientMessageHandler h = new ClientMessageHandler(s, this);
                    this.clientHandlers.add(h);
                    new Thread(h).start();
                    Verbose.show("... R client has connected  on port " + this.portRJ);
                }
                catch (Exception xxx) {
                    Verbose.show("RReClientApp.run(): ", xxx);
                }
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void shutdown() {
        Verbose.show("RReClientApp.shutdown()");
        System.exit(0);
    }

    public void closeAllAndShutdown() {
        for (ClientMessageHandler h : this.clientHandlers) {
            h.closeAllConnections();
        }
        this.shutdown();
    }

    public void remove(ClientMessageHandler mHandler) {
        this.clientHandlers.remove(mHandler);
    }

    public int getNHandlers() {
        return this.clientHandlers.size();
    }

    public static void main(String[] argv) {
        int portR = ArgvUtil.getIntVal((String[])argv, (String)"portRJ", (int)4460);
        Verbose.verbose = Boolean.parseBoolean(ArgvUtil.getVal((String[])argv, (String)"verbose", (String)"true"));
        RReClientApp app = new RReClientApp(portR, argv);
        app.launch();
    }
}

