% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SDMXDotStatRequestBuilder.R,
%   R/SDMXDotStatRequestBuilder-methods.R
\docType{class}
\name{SDMXDotStatRequestBuilder}
\alias{SDMXDotStatRequestBuilder}
\alias{SDMXDotStatRequestBuilder-class}
\alias{SDMXDotStatRequestBuilder,SDMXDotStatRequestBuilder-method}
\title{Class "SDMXDotStatRequestBuilder"}
\usage{
SDMXDotStatRequestBuilder(regUrl, repoUrl, accessKey = NULL,
   unsupportedResources = list(), skipProviderId = FALSE, forceProviderId = FALSE,
   headers = list())
}
\arguments{
\item{regUrl}{an object of class "character" giving the base Url of the SDMX service registry}

\item{repoUrl}{an object of class "character" giving the base Url of the SDMX service repository}

\item{accessKey}{an object of class "character" indicating the name of request parameter for which
an authentication or subscription user key (token) has to be provided to perform requests}

\item{unsupportedResources}{an object of class "list" giving eventual unsupported 
REST resources. Default is an empty list object}

\item{skipProviderId}{an object of class "logical" indicating that the provider
agencyId should be skipped. Used to control lack of strong SDMX REST compliance 
from data providers. For now, it applies only for the "data" resource.}

\item{forceProviderId}{an object of class "logical" indicating if the provider
agencyId has to be added at the end of the request. Default value is 
\code{FALSE}. For some providers, the \code{all} value for the provider
agency id is not allowed, in this case, the \code{agencyId} of the data provider 
has to be forced in the web-request}

\item{headers}{an object of class "list" that contains any additional headers for the request.}
}
\description{
A experimental class to handle a SDMX DotStat (*.Stat) service 
             request builder
}
\section{Slots}{

\describe{
\item{\code{regUrl}}{an object of class "character" giving the base Url of the SDMX service registry}

\item{\code{repoUrl}}{an object of class "character" giving the base Url of the SDMX service repository}

\item{\code{accessKey}}{an object of class "character" indicating the name of request parameter for which
an authentication or subscription user key/token has to be provided to perform requests}

\item{\code{compliant}}{an object of class "logical" indicating if the request builder is somehow compliant with a service specification}
}}

\note{
Internal class
}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will 
encapsulate it as slot, when parsing an SDMX-ML document.
}

\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
