% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_SETSe_binary.R
\name{prepare_SETSe_binary}
\alias{prepare_SETSe_binary}
\title{Binary network prepare}
\usage{
prepare_SETSe_binary(
  g,
  node_names,
  k = NULL,
  force_var,
  positive_value,
  sum_to_one = TRUE,
  distance = 1
)
}
\arguments{
\item{g}{an igraph object}

\item{node_names}{a character string. A vertex attribute which contains the node names.}

\item{k}{The spring constant. This value is either a numeric value giving the spring constant for all edges or NULL. If NULL is used 
the k value will not be added to the network. This is useful k is made through some other process.}

\item{force_var}{A node attribute. This is used as the force variable, it must be a character of factor}

\item{positive_value}{The value in force var that will be counted as the positive value}

\item{sum_to_one}{Logical. whether the total positive force sums to 1, if FALSE the total is the sum of the positive cases}

\item{distance}{a positive numeric value. The default is 1}
}
\value{
A network with the correct edge and node attributes for the embeddings process.
}
\description{
This function prepares a binary network for SETSe projection.
}
\details{
The network takes in an igraph object and produces an undirected igraph object that can be used with SETSe/SETSe_auto/SETSe_bicomp for embedding.

The function adds the node attribute 'force' and the edge attribute 'k' unless k=NULL. The purpose of the function is to easily be able to 
 project binary networks using SETSe. 
 
 The function creates several variables
\itemize{
  \item force: a vertex attribute representing the force produced by each node. The sum of this variable will be 0
  \item k: The spring constant representing the stiffness of the spring. 
  \item edge_name: the name of the edges. it takes the form "from_to" where "from" is the origin node and "to" is the destination node using the 
 \code{\link[igraph]{as_data_frame}} function from igraph
}
}
\examples{
set.seed(234) #set the random see for generating the network
g <- generate_peels_network(type = "E")
embeddings <- g \%>\%
#prepare the network for a binary embedding
prepare_SETSe_binary(., node_names = "name", k = 1000, 
                     force_var = "class", 
                     positive_value = "A") \%>\%
#embed the network using auto setse
  SETSe_auto()

}
\seealso{
\code{\link{SETSe}}, \code{\link{SETSe_auto}}, \code{\link{SETSe_bicomp}}, \code{\link{prepare_SETSe_continuous}}
}
