% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.simsum}
\alias{tidy.simsum}
\alias{tidy.summary.simsum}
\alias{tidy.multisimsum}
\alias{tidy.summary.multisimsum}
\title{Turn an object into a tidy dataset}
\usage{
\method{tidy}{simsum}(x, stats = NULL, ...)

\method{tidy}{summary.simsum}(x, stats = NULL, ...)

\method{tidy}{multisimsum}(x, stats = NULL, ...)

\method{tidy}{summary.multisimsum}(x, stats = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{simsum}.}

\item{stats}{Summary statistics to include; can be a scalar value or a vector. Possible choices are:
\itemize{
\item \code{nsim}, the number of replications with non-missing point estimates and standard error.
\item \code{thetamean}, average point estimate.
\item \code{thetamedian}, median point estimate.
\item \code{se2mean}, average standard error.
\item \code{se2median}, median standard error.
\item \code{bias}, bias in point estimate.
\item \code{empse}, empirical standard error.
\item \code{mse}, mean squared error.
\item \code{relprec}, percentage gain in precision relative to the reference method.
\item \code{modelse}, model-based standard error.
\item \code{relerror}, relative percentage error in standard error.
\item \code{cover}, coverage of a nominal \code{level}\\% confidence interval.
\item \code{becover}, bias-eliminated coverage of a nominal \code{level}\\% confidence interval.
\item \code{power}, power of a (1 - \code{level})\\% level test.
Defaults to \code{NULL}, in which case all summary statistics are returned.
}}

\item{...}{Ignored.}
}
\value{
A \code{data.frame} containing summary statistics from a simulation study.
}
\description{
Extract a tidy dataset with results from an object of class \code{simsum}, \code{summary.simsum}, \code{multisimsum}, or \code{summary.multisimsum}.
}
\examples{
data(MIsim)
x <- simsum(
  data = MIsim, estvarname = "b", true = 0.5, se = "se",
  methodvar = "method"
)
tidy(x)

# Extracting only bias and coverage:
tidy(x, stats = c("bias", "cover"))

xs <- summary(x)
tidy(xs)
}
