context("zip")
library(ggplot2)

test_that("zip checks arguments properly", {
  data("MIsim", package = "rsimsum")
  data("frailty", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method", x = TRUE)
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", x = TRUE)
  expect_error(zip(obj = MIsim))
  expect_error(zip(obj = s, wald.level = 101))
  expect_error(zip(obj = s, gpars = list(wrong.parameter = 1)))
  expect_error(zip(obj = sm, wald.level = 101))
  expect_error(zip(obj = sm, par = "hello"))
  expect_error(zip(obj = sm, gpars = list(wrong.parameter = 1)))
})

test_that("zip fails when simsum/multisimsum are called with x = FALSE", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model")
  expect_error(zip(s))
  expect_error(zip(sm, par = "trt"))
})

test_that("zip returns a ggplot object", {
  data("MIsim", package = "rsimsum")
  data("frailty", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method", x = TRUE)
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", x = TRUE)
  expect_s3_class(zip(s), class = c("gg", "ggplot"))
  expect_s3_class(zip(sm, par = "trt"), class = c("gg", "ggplot"))
})

test_that("zip works when changing graphical parameters", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method", x = TRUE)
  zip(s, gpars = list(ci.alpha = 1))
  zip(s, gpars = list(true.colour = 2))
  zip(s, gpars = list(true.shape = 3))
  zip(s, gpars = list(ci.colour = 4))
  zip(s, gpars = list(ci.shape = 5))
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", x = TRUE)
  zip(sm, par = "trt", gpars = list(ci.alpha = 1))
  zip(sm, par = "trt", gpars = list(true.colour = 2))
  zip(sm, par = "trt", gpars = list(true.shape = 3))
  zip(sm, par = "trt", gpars = list(ci.colour = 4))
  zip(sm, par = "trt", gpars = list(ci.shape = 5))
})

test_that("zip works with all possible combinations of `methodvar`, `by`", {
  data("relhaz", package = "rsimsum")
  zip(simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se", methodvar = "model", by = c("n", "baseline"), x = TRUE))
  zip(simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se", by = c("n", "baseline"), x = TRUE))
  zip(simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se", methodvar = "model", x = TRUE))
  zip(simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se", x = TRUE))
  data("frailty", package = "rsimsum")
  zip(multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist", x = TRUE), par = "trt")
  zip(multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", by = "fv_dist", x = TRUE), par = "trt")
  zip(multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", x = TRUE), par = "trt")
  zip(multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", x = TRUE), par = "trt")
})
