% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_FTRL.R
\name{FTRL}
\alias{FTRL}
\title{Logistic regression model with FTRL proximal SGD solver.}
\description{
Creates 'Follow the Regularized Leader' model.
Only logistic regression implemented at the moment.
}
\examples{
library(rsparse)
library(Matrix)
i = sample(1000, 1000 * 100, TRUE)
j = sample(1000, 1000 * 100, TRUE)
y = sample(c(0, 1), 1000, TRUE)
x = sample(c(-1, 1), 1000 * 100, TRUE)
odd = seq(1, 99, 2)
x[i \%in\% which(y == 1) & j \%in\% odd] = 1
x = sparseMatrix(i = i, j = j, x = x, dims = c(1000, 1000), repr="R")

ftrl = FTRL$new(learning_rate = 0.01, learning_rate_decay = 0.1,
lambda = 10, l1_ratio = 1, dropout = 0)
ftrl$partial_fit(x, y)

w = ftrl$coef()
head(w)
sum(w != 0)
p = ftrl$predict(x)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FTRL$new()}}
\item \href{#method-partial_fit}{\code{FTRL$partial_fit()}}
\item \href{#method-fit}{\code{FTRL$fit()}}
\item \href{#method-predict}{\code{FTRL$predict()}}
\item \href{#method-coef}{\code{FTRL$coef()}}
\item \href{#method-clone}{\code{FTRL$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
creates a model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$new(
  learning_rate = 0.1,
  learning_rate_decay = 0.5,
  lambda = 0,
  l1_ratio = 1,
  dropout = 0,
  family = c("binomial")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learning_rate}}{learning rate}

\item{\code{learning_rate_decay}}{learning rate which controls decay. Please refer to FTRL proximal
paper for details. Usually convergense does not heavily depend on this parameter,
so default value 0.5 is safe.}

\item{\code{lambda}}{regularization parameter}

\item{\code{l1_ratio}}{controls L1 vs L2 penalty mixing.
1 = Lasso regression, 0 = Ridge regression. Elastic net is in between}

\item{\code{dropout}}{dropout - percentage of random features to
exclude from each sample. Acts as regularization.}

\item{\code{family}}{a description of the error distribution and link function to be used in
the model. Only \code{binomial} (logistic regression) is implemented at the moment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-partial_fit"></a>}}
\if{latex}{\out{\hypertarget{method-partial_fit}{}}}
\subsection{Method \code{partial_fit()}}{
fits model to the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$partial_fit(x, y, weights = rep(1, length(y)), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse matrix. Native format is \code{Matrix::RsparseMatrix}.
If \code{x} is in different format, model will try to convert it to \code{RsparseMatrix}
with \code{as(x, "RsparseMatrix")}. Dimensions should be (n_samples, n_features)}

\item{\code{y}}{vector of targets}

\item{\code{weights}}{numeric vector of length `n_samples`. Defines how to amplify SGD updates
for each sample. May be useful for highly unbalanced problems.}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
shorthand for applying `partial_fit` `n_iter` times
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$fit(x, y, weights = rep(1, length(y)), n_iter = 1L, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse matrix. Native format is \code{Matrix::RsparseMatrix}.
If \code{x} is in different format, model will try to convert it to \code{RsparseMatrix}
with \code{as(x, "RsparseMatrix")}. Dimensions should be (n_samples, n_features)}

\item{\code{y}}{vector of targets}

\item{\code{weights}}{numeric vector of length `n_samples`. Defines how to amplify SGD updates
for each sample. May be useful for highly unbalanced problems.}

\item{\code{n_iter}}{number of SGD epochs}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
makes predictions based on fitted model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$predict(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input matrix}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-coef"></a>}}
\if{latex}{\out{\hypertarget{method-coef}{}}}
\subsection{Method \code{coef()}}{
returns coefficients of the regression model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$coef()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FTRL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
