// Generated by rstantools.  Do not edit by hand.

/*
    rstanemax is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanemax is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanemax.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_emax_binary_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 83> locations_array__ =
  {" (found before start of program)",
  " (in 'emax_binary', line 33, column 2 to column 40)",
  " (in 'emax_binary', line 35, column 2 to column 47)",
  " (in 'emax_binary', line 36, column 2 to column 53)",
  " (in 'emax_binary', line 37, column 2 to column 51)",
  " (in 'emax_binary', line 40, column 2 to column 21)",
  " (in 'emax_binary', line 41, column 2 to column 25)",
  " (in 'emax_binary', line 42, column 2 to column 13)",
  " (in 'emax_binary', line 43, column 2 to column 25)",
  " (in 'emax_binary', line 44, column 2 to column 29)",
  " (in 'emax_binary', line 45, column 2 to column 20)",
  " (in 'emax_binary', line 46, column 2 to column 20)",
  " (in 'emax_binary', line 47, column 2 to column 24)",
  " (in 'emax_binary', line 48, column 2 to column 18)",
  " (in 'emax_binary', line 76, column 2 to column 20)",
  " (in 'emax_binary', line 50, column 2 to column 57)",
  " (in 'emax_binary', line 51, column 26 to column 75)",
  " (in 'emax_binary', line 51, column 2 to column 75)",
  " (in 'emax_binary', line 52, column 28 to column 85)",
  " (in 'emax_binary', line 52, column 2 to column 85)",
  " (in 'emax_binary', line 54, column 2 to column 26)",
  " (in 'emax_binary', line 55, column 2 to column 26)",
  " (in 'emax_binary', line 56, column 2 to column 22)",
  " (in 'emax_binary', line 58, column 4 to column 40)",
  " (in 'emax_binary', line 59, column 4 to column 39)",
  " (in 'emax_binary', line 57, column 16 to line 60, column 3)",
  " (in 'emax_binary', line 57, column 2 to line 60, column 3)",
  " (in 'emax_binary', line 61, column 2 to column 77)",
  " (in 'emax_binary', line 78, column 4 to column 65)",
  " (in 'emax_binary', line 77, column 17 to line 79, column 3)",
  " (in 'emax_binary', line 77, column 2 to line 79, column 3)",
  " (in 'emax_binary', line 64, column 2 to column 39)",
  " (in 'emax_binary', line 66, column 2 to column 54)",
  " (in 'emax_binary', line 67, column 2 to column 55)",
  " (in 'emax_binary', line 69, column 4 to column 53)",
  " (in 'emax_binary', line 68, column 26 to line 70, column 3)",
  " (in 'emax_binary', line 68, column 2 to line 70, column 3)",
  " (in 'emax_binary', line 72, column 4 to column 59)",
  " (in 'emax_binary', line 71, column 28 to line 73, column 3)",
  " (in 'emax_binary', line 71, column 2 to line 73, column 3)",
  " (in 'emax_binary', line 2, column 2 to column 19)",
  " (in 'emax_binary', line 3, column 20 to column 21)",
  " (in 'emax_binary', line 3, column 2 to column 32)",
  " (in 'emax_binary', line 4, column 8 to column 9)",
  " (in 'emax_binary', line 4, column 2 to column 42)",
  " (in 'emax_binary', line 6, column 8 to column 9)",
  " (in 'emax_binary', line 6, column 2 to column 34)",
  " (in 'emax_binary', line 7, column 8 to column 9)",
  " (in 'emax_binary', line 7, column 2 to column 34)",
  " (in 'emax_binary', line 8, column 8 to column 9)",
  " (in 'emax_binary', line 8, column 2 to column 32)",
  " (in 'emax_binary', line 9, column 2 to column 31)",
  " (in 'emax_binary', line 10, column 2 to column 31)",
  " (in 'emax_binary', line 11, column 2 to column 29)",
  " (in 'emax_binary', line 13, column 2 to column 37)",
  " (in 'emax_binary', line 14, column 2 to column 34)",
  " (in 'emax_binary', line 15, column 2 to column 36)",
  " (in 'emax_binary', line 16, column 2 to column 32)",
  " (in 'emax_binary', line 17, column 2 to column 20)",
  " (in 'emax_binary', line 18, column 2 to column 22)",
  " (in 'emax_binary', line 21, column 2 to column 21)",
  " (in 'emax_binary', line 22, column 2 to column 30)",
  " (in 'emax_binary', line 23, column 2 to column 31)",
  " (in 'emax_binary', line 24, column 2 to column 19)",
  " (in 'emax_binary', line 26, column 2 to column 31)",
  " (in 'emax_binary', line 27, column 2 to column 31)",
  " (in 'emax_binary', line 28, column 2 to column 32)",
  " (in 'emax_binary', line 29, column 2 to column 29)",
  " (in 'emax_binary', line 33, column 20 to column 33)",
  " (in 'emax_binary', line 35, column 8 to column 19)",
  " (in 'emax_binary', line 35, column 21 to column 33)",
  " (in 'emax_binary', line 36, column 8 to column 21)",
  " (in 'emax_binary', line 36, column 23 to column 37)",
  " (in 'emax_binary', line 37, column 8 to column 23)",
  " (in 'emax_binary', line 40, column 9 to column 10)",
  " (in 'emax_binary', line 41, column 9 to column 10)",
  " (in 'emax_binary', line 43, column 9 to column 20)",
  " (in 'emax_binary', line 44, column 9 to column 22)",
  " (in 'emax_binary', line 45, column 9 to column 10)",
  " (in 'emax_binary', line 46, column 9 to column 10)",
  " (in 'emax_binary', line 47, column 9 to column 10)",
  " (in 'emax_binary', line 48, column 9 to column 10)",
  " (in 'emax_binary', line 76, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_emax_binary final : public model_base_crtp<model_emax_binary> {
private:
  int N;
  Eigen::Matrix<double,-1,1> exposure_data__;
  std::vector<int> response;
  std::vector<int> covemax;
  std::vector<int> covec50;
  std::vector<int> cove0;
  int n_covlev_emax;
  int n_covlev_ec50;
  int n_covlev_e0;
  int gamma_fix_flg;
  int e0_fix_flg;
  int emax_fix_flg;
  double gamma_fix_value;
  double e0_fix_value;
  double emax_fix_value;
  double prior_emax_mu;
  double prior_ec50_mu;
  double prior_gamma_mu;
  double prior_e0_mu;
  double prior_emax_sig;
  double prior_ec50_sig;
  double prior_gamma_sig;
  double prior_e0_sig;
  int e0_par_2dim__;
  int emax_par_2dim__;
  int gamma_par_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> exposure{nullptr, 0};
public:
  ~model_emax_binary() {}
  model_emax_binary(stan::io::var_context& context__, unsigned int
                    random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_emax_binary_namespace::model_emax_binary";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 40;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 40;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("exposure", "N", N);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "exposure", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      exposure_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                          std::numeric_limits<double>::quiet_NaN());
      new (&exposure)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(exposure_data__.data(), N);
      {
        std::vector<local_scalar_t__> exposure_flat__;
        current_statement__ = 42;
        exposure_flat__ = context__.vals_r("exposure");
        current_statement__ = 42;
        pos__ = 1;
        current_statement__ = 42;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 42;
          stan::model::assign(exposure, exposure_flat__[(pos__ - 1)],
            "assigning variable exposure", stan::model::index_uni(sym1__));
          current_statement__ = 42;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "exposure", exposure, 0);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("response", "N", N);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "response", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      response = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 44;
      response = context__.vals_i("response");
      current_statement__ = 44;
      stan::math::check_greater_or_equal(function__, "response", response, 0);
      current_statement__ = 44;
      stan::math::check_less_or_equal(function__, "response", response, 1);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("covemax", "N", N);
      current_statement__ = 46;
      context__.validate_dims("data initialization", "covemax", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      covemax = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 46;
      covemax = context__.vals_i("covemax");
      current_statement__ = 46;
      stan::math::check_greater_or_equal(function__, "covemax", covemax, 1);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("covec50", "N", N);
      current_statement__ = 48;
      context__.validate_dims("data initialization", "covec50", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      covec50 = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 48;
      covec50 = context__.vals_i("covec50");
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "covec50", covec50, 1);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("cove0", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "cove0", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      cove0 = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 50;
      cove0 = context__.vals_i("cove0");
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "cove0", cove0, 1);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "n_covlev_emax", "int",
        std::vector<size_t>{});
      n_covlev_emax = std::numeric_limits<int>::min();
      current_statement__ = 51;
      n_covlev_emax = context__.vals_i("n_covlev_emax")[(1 - 1)];
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "n_covlev_emax",
        n_covlev_emax, 1);
      current_statement__ = 52;
      context__.validate_dims("data initialization", "n_covlev_ec50", "int",
        std::vector<size_t>{});
      n_covlev_ec50 = std::numeric_limits<int>::min();
      current_statement__ = 52;
      n_covlev_ec50 = context__.vals_i("n_covlev_ec50")[(1 - 1)];
      current_statement__ = 52;
      stan::math::check_greater_or_equal(function__, "n_covlev_ec50",
        n_covlev_ec50, 1);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "n_covlev_e0", "int",
        std::vector<size_t>{});
      n_covlev_e0 = std::numeric_limits<int>::min();
      current_statement__ = 53;
      n_covlev_e0 = context__.vals_i("n_covlev_e0")[(1 - 1)];
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "n_covlev_e0",
        n_covlev_e0, 1);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "gamma_fix_flg", "int",
        std::vector<size_t>{});
      gamma_fix_flg = std::numeric_limits<int>::min();
      current_statement__ = 54;
      gamma_fix_flg = context__.vals_i("gamma_fix_flg")[(1 - 1)];
      current_statement__ = 54;
      stan::math::check_greater_or_equal(function__, "gamma_fix_flg",
        gamma_fix_flg, 0);
      current_statement__ = 54;
      stan::math::check_less_or_equal(function__, "gamma_fix_flg",
        gamma_fix_flg, 1);
      current_statement__ = 55;
      context__.validate_dims("data initialization", "e0_fix_flg", "int",
        std::vector<size_t>{});
      e0_fix_flg = std::numeric_limits<int>::min();
      current_statement__ = 55;
      e0_fix_flg = context__.vals_i("e0_fix_flg")[(1 - 1)];
      current_statement__ = 55;
      stan::math::check_greater_or_equal(function__, "e0_fix_flg",
        e0_fix_flg, 0);
      current_statement__ = 55;
      stan::math::check_less_or_equal(function__, "e0_fix_flg", e0_fix_flg, 1);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "emax_fix_flg", "int",
        std::vector<size_t>{});
      emax_fix_flg = std::numeric_limits<int>::min();
      current_statement__ = 56;
      emax_fix_flg = context__.vals_i("emax_fix_flg")[(1 - 1)];
      current_statement__ = 56;
      stan::math::check_greater_or_equal(function__, "emax_fix_flg",
        emax_fix_flg, 0);
      current_statement__ = 56;
      stan::math::check_less_or_equal(function__, "emax_fix_flg",
        emax_fix_flg, 1);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "gamma_fix_value",
        "double", std::vector<size_t>{});
      gamma_fix_value = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 57;
      gamma_fix_value = context__.vals_r("gamma_fix_value")[(1 - 1)];
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "gamma_fix_value",
        gamma_fix_value, 0);
      current_statement__ = 58;
      context__.validate_dims("data initialization", "e0_fix_value",
        "double", std::vector<size_t>{});
      e0_fix_value = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 58;
      e0_fix_value = context__.vals_r("e0_fix_value")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization", "emax_fix_value",
        "double", std::vector<size_t>{});
      emax_fix_value = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 59;
      emax_fix_value = context__.vals_r("emax_fix_value")[(1 - 1)];
      current_statement__ = 60;
      context__.validate_dims("data initialization", "prior_emax_mu",
        "double", std::vector<size_t>{});
      prior_emax_mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 60;
      prior_emax_mu = context__.vals_r("prior_emax_mu")[(1 - 1)];
      current_statement__ = 61;
      context__.validate_dims("data initialization", "prior_ec50_mu",
        "double", std::vector<size_t>{});
      prior_ec50_mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 61;
      prior_ec50_mu = context__.vals_r("prior_ec50_mu")[(1 - 1)];
      current_statement__ = 61;
      stan::math::check_greater_or_equal(function__, "prior_ec50_mu",
        prior_ec50_mu, 0);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "prior_gamma_mu",
        "double", std::vector<size_t>{});
      prior_gamma_mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 62;
      prior_gamma_mu = context__.vals_r("prior_gamma_mu")[(1 - 1)];
      current_statement__ = 62;
      stan::math::check_greater_or_equal(function__, "prior_gamma_mu",
        prior_gamma_mu, 0);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "prior_e0_mu", "double",
        std::vector<size_t>{});
      prior_e0_mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 63;
      prior_e0_mu = context__.vals_r("prior_e0_mu")[(1 - 1)];
      current_statement__ = 64;
      context__.validate_dims("data initialization", "prior_emax_sig",
        "double", std::vector<size_t>{});
      prior_emax_sig = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 64;
      prior_emax_sig = context__.vals_r("prior_emax_sig")[(1 - 1)];
      current_statement__ = 64;
      stan::math::check_greater_or_equal(function__, "prior_emax_sig",
        prior_emax_sig, 0);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "prior_ec50_sig",
        "double", std::vector<size_t>{});
      prior_ec50_sig = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 65;
      prior_ec50_sig = context__.vals_r("prior_ec50_sig")[(1 - 1)];
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "prior_ec50_sig",
        prior_ec50_sig, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "prior_gamma_sig",
        "double", std::vector<size_t>{});
      prior_gamma_sig = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 66;
      prior_gamma_sig = context__.vals_r("prior_gamma_sig")[(1 - 1)];
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "prior_gamma_sig",
        prior_gamma_sig, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "prior_e0_sig",
        "double", std::vector<size_t>{});
      prior_e0_sig = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 67;
      prior_e0_sig = context__.vals_r("prior_e0_sig")[(1 - 1)];
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "prior_e0_sig",
        prior_e0_sig, 0);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("ec50", "n_covlev_ec50",
        n_covlev_ec50);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("e0_par", "n_covlev_e0",
        n_covlev_e0);
      current_statement__ = 70;
      e0_par_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 70;
      e0_par_2dim__ = (1 - e0_fix_flg);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("e0_par", "1 - e0_fix_flg",
        e0_par_2dim__);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("emax_par", "n_covlev_emax",
        n_covlev_emax);
      current_statement__ = 72;
      emax_par_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 72;
      emax_par_2dim__ = (1 - emax_fix_flg);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("emax_par", "1 - emax_fix_flg",
        emax_par_2dim__);
      current_statement__ = 73;
      gamma_par_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 73;
      gamma_par_1dim__ = (1 - gamma_fix_flg);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("gamma_par",
        "1 - gamma_fix_flg", gamma_par_1dim__);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("mu_logit", "N", N);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("exposure_exp", "N", N);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("e0", "n_covlev_e0",
        n_covlev_e0);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("emax", "n_covlev_emax",
        n_covlev_emax);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("emaxvec", "N", N);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("ec50vec", "N", N);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("ec50vec_exp", "N", N);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("e0vec", "N", N);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = n_covlev_ec50 + (n_covlev_e0 * e0_par_2dim__) +
      (n_covlev_emax * emax_par_2dim__) + gamma_par_1dim__;
  }
  inline std::string model_name() const final {
    return "model_emax_binary";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_emax_binary_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> ec50 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_covlev_ec50,
          DUMMY_VAR__);
      current_statement__ = 1;
      ec50 = in__.template read_constrain_lb<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
               n_covlev_ec50);
      std::vector<std::vector<local_scalar_t__>> e0_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_e0,
          std::vector<local_scalar_t__>(e0_par_2dim__, DUMMY_VAR__));
      current_statement__ = 2;
      e0_par = in__.template read<
                 std::vector<std::vector<local_scalar_t__>>>(n_covlev_e0,
                 e0_par_2dim__);
      std::vector<std::vector<local_scalar_t__>> emax_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_emax,
          std::vector<local_scalar_t__>(emax_par_2dim__, DUMMY_VAR__));
      current_statement__ = 3;
      emax_par = in__.template read<
                   std::vector<std::vector<local_scalar_t__>>>(n_covlev_emax,
                   emax_par_2dim__);
      std::vector<local_scalar_t__> gamma_par =
        std::vector<local_scalar_t__>(gamma_par_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      gamma_par = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    gamma_par_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_logit =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> exposure_exp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      local_scalar_t__ gamma = DUMMY_VAR__;
      Eigen::Matrix<local_scalar_t__,-1,1> e0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_covlev_e0,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> emax =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_covlev_emax,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> emaxvec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> ec50vec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> ec50vec_exp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> e0vec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 15;
      gamma = (gamma_fix_flg ? gamma_fix_value : stan::model::rvalue(
                                                   gamma_par, "gamma_par",
                                                   stan::model::index_uni(1)));
      current_statement__ = 17;
      for (int i = 1; i <= n_covlev_e0; ++i) {
        current_statement__ = 16;
        stan::model::assign(e0,
          (e0_fix_flg ? e0_fix_value : stan::model::rvalue(e0_par, "e0_par",
                                         stan::model::index_uni(i),
                                         stan::model::index_uni(1))),
          "assigning variable e0", stan::model::index_uni(i));
      }
      current_statement__ = 19;
      for (int i = 1; i <= n_covlev_emax; ++i) {
        current_statement__ = 18;
        stan::model::assign(emax,
          (emax_fix_flg ? emax_fix_value : stan::model::rvalue(emax_par,
                                             "emax_par",
                                             stan::model::index_uni(i),
                                             stan::model::index_uni(1))),
          "assigning variable emax", stan::model::index_uni(i));
      }
      current_statement__ = 20;
      stan::model::assign(emaxvec,
        stan::model::rvalue(emax, "emax", stan::model::index_multi(covemax)),
        "assigning variable emaxvec");
      current_statement__ = 21;
      stan::model::assign(ec50vec,
        stan::model::rvalue(ec50, "ec50", stan::model::index_multi(covec50)),
        "assigning variable ec50vec");
      current_statement__ = 22;
      stan::model::assign(e0vec,
        stan::model::rvalue(e0, "e0", stan::model::index_multi(cove0)),
        "assigning variable e0vec");
      current_statement__ = 26;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 23;
        stan::model::assign(exposure_exp,
          stan::math::pow(
            stan::model::rvalue(exposure, "exposure",
              stan::model::index_uni(i)), gamma),
          "assigning variable exposure_exp", stan::model::index_uni(i));
        current_statement__ = 24;
        stan::model::assign(ec50vec_exp,
          stan::math::pow(
            stan::model::rvalue(ec50vec, "ec50vec", stan::model::index_uni(i)),
            gamma), "assigning variable ec50vec_exp",
          stan::model::index_uni(i));
      }
      current_statement__ = 27;
      stan::model::assign(mu_logit,
        stan::math::add(e0vec,
          stan::math::elt_divide(
            stan::math::elt_multiply(emaxvec, exposure_exp),
            stan::math::add(ec50vec_exp, exposure_exp))),
        "assigning variable mu_logit");
      {
        current_statement__ = 31;
        lp_accum__.add(stan::math::bernoulli_logit_lpmf<propto__>(response,
                         mu_logit));
        current_statement__ = 32;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(ec50, prior_ec50_mu,
                         prior_ec50_sig));
        current_statement__ = 33;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(gamma_par,
                         prior_gamma_mu, prior_gamma_sig));
        current_statement__ = 36;
        for (int i = 1; i <= n_covlev_e0; ++i) {
          current_statement__ = 34;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(e0_par, "e0_par",
                             stan::model::index_uni(i)), prior_e0_mu,
                           prior_e0_sig));
        }
        current_statement__ = 39;
        for (int i = 1; i <= n_covlev_emax; ++i) {
          current_statement__ = 37;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(emax_par, "emax_par",
                             stan::model::index_uni(i)), prior_emax_mu,
                           prior_emax_sig));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_emax_binary_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> ec50 =
        Eigen::Matrix<double,-1,1>::Constant(n_covlev_ec50,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      ec50 = in__.template read_constrain_lb<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
               n_covlev_ec50);
      std::vector<std::vector<double>> e0_par =
        std::vector<std::vector<double>>(n_covlev_e0,
          std::vector<double>(e0_par_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 2;
      e0_par = in__.template read<
                 std::vector<std::vector<local_scalar_t__>>>(n_covlev_e0,
                 e0_par_2dim__);
      std::vector<std::vector<double>> emax_par =
        std::vector<std::vector<double>>(n_covlev_emax,
          std::vector<double>(emax_par_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 3;
      emax_par = in__.template read<
                   std::vector<std::vector<local_scalar_t__>>>(n_covlev_emax,
                   emax_par_2dim__);
      std::vector<double> gamma_par =
        std::vector<double>(gamma_par_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      gamma_par = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    gamma_par_1dim__);
      Eigen::Matrix<double,-1,1> mu_logit =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> exposure_exp =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      double gamma = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> e0 =
        Eigen::Matrix<double,-1,1>::Constant(n_covlev_e0,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> emax =
        Eigen::Matrix<double,-1,1>::Constant(n_covlev_emax,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> emaxvec =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> ec50vec =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> ec50vec_exp =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> e0vec =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(ec50);
      for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
          out__.write(e0_par[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
          out__.write(emax_par[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(gamma_par);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 15;
      gamma = (gamma_fix_flg ? gamma_fix_value : stan::model::rvalue(
                                                   gamma_par, "gamma_par",
                                                   stan::model::index_uni(1)));
      current_statement__ = 17;
      for (int i = 1; i <= n_covlev_e0; ++i) {
        current_statement__ = 16;
        stan::model::assign(e0,
          (e0_fix_flg ? e0_fix_value : stan::model::rvalue(e0_par, "e0_par",
                                         stan::model::index_uni(i),
                                         stan::model::index_uni(1))),
          "assigning variable e0", stan::model::index_uni(i));
      }
      current_statement__ = 19;
      for (int i = 1; i <= n_covlev_emax; ++i) {
        current_statement__ = 18;
        stan::model::assign(emax,
          (emax_fix_flg ? emax_fix_value : stan::model::rvalue(emax_par,
                                             "emax_par",
                                             stan::model::index_uni(i),
                                             stan::model::index_uni(1))),
          "assigning variable emax", stan::model::index_uni(i));
      }
      current_statement__ = 20;
      stan::model::assign(emaxvec,
        stan::model::rvalue(emax, "emax", stan::model::index_multi(covemax)),
        "assigning variable emaxvec");
      current_statement__ = 21;
      stan::model::assign(ec50vec,
        stan::model::rvalue(ec50, "ec50", stan::model::index_multi(covec50)),
        "assigning variable ec50vec");
      current_statement__ = 22;
      stan::model::assign(e0vec,
        stan::model::rvalue(e0, "e0", stan::model::index_multi(cove0)),
        "assigning variable e0vec");
      current_statement__ = 26;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 23;
        stan::model::assign(exposure_exp,
          stan::math::pow(
            stan::model::rvalue(exposure, "exposure",
              stan::model::index_uni(i)), gamma),
          "assigning variable exposure_exp", stan::model::index_uni(i));
        current_statement__ = 24;
        stan::model::assign(ec50vec_exp,
          stan::math::pow(
            stan::model::rvalue(ec50vec, "ec50vec", stan::model::index_uni(i)),
            gamma), "assigning variable ec50vec_exp",
          stan::model::index_uni(i));
      }
      current_statement__ = 27;
      stan::model::assign(mu_logit,
        stan::math::add(e0vec,
          stan::math::elt_divide(
            stan::math::elt_multiply(emaxvec, exposure_exp),
            stan::math::add(ec50vec_exp, exposure_exp))),
        "assigning variable mu_logit");
      if (emit_transformed_parameters__) {
        out__.write(mu_logit);
        out__.write(exposure_exp);
        out__.write(gamma);
        out__.write(e0);
        out__.write(emax);
        out__.write(emaxvec);
        out__.write(ec50vec);
        out__.write(ec50vec_exp);
        out__.write(e0vec);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 30;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 28;
        stan::model::assign(log_lik,
          stan::math::bernoulli_logit_lpmf<false>(
            stan::model::rvalue(response, "response",
              stan::model::index_uni(n)),
            stan::model::rvalue(mu_logit, "mu_logit",
              stan::model::index_uni(n))), "assigning variable log_lik",
          stan::model::index_uni(n));
      }
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> ec50 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_covlev_ec50,
          DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(ec50,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_covlev_ec50),
        "assigning variable ec50");
      out__.write_free_lb(0, ec50);
      std::vector<std::vector<local_scalar_t__>> e0_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_e0,
          std::vector<local_scalar_t__>(e0_par_2dim__, DUMMY_VAR__));
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
          current_statement__ = 2;
          e0_par[(sym2__ - 1)][(sym1__ - 1)] = in__.read<local_scalar_t__>();
        }
      }
      out__.write(e0_par);
      std::vector<std::vector<local_scalar_t__>> emax_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_emax,
          std::vector<local_scalar_t__>(emax_par_2dim__, DUMMY_VAR__));
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
          current_statement__ = 3;
          emax_par[(sym2__ - 1)][(sym1__ -
            1)] = in__.read<local_scalar_t__>();
        }
      }
      out__.write(emax_par);
      std::vector<local_scalar_t__> gamma_par =
        std::vector<local_scalar_t__>(gamma_par_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(gamma_par,
        in__.read<std::vector<local_scalar_t__>>(gamma_par_1dim__),
        "assigning variable gamma_par");
      out__.write_free_lb(0, gamma_par);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "ec50", "double",
        std::vector<size_t>{static_cast<size_t>(n_covlev_ec50)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "e0_par", "double",
        std::vector<size_t>{static_cast<size_t>(n_covlev_e0),
          static_cast<size_t>(e0_par_2dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "emax_par",
        "double",
        std::vector<size_t>{static_cast<size_t>(n_covlev_emax),
          static_cast<size_t>(emax_par_2dim__)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "gamma_par",
        "double", std::vector<size_t>{static_cast<size_t>(gamma_par_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> ec50 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_covlev_ec50,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> ec50_flat__;
        current_statement__ = 1;
        ec50_flat__ = context__.vals_r("ec50");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(ec50, ec50_flat__[(pos__ - 1)],
            "assigning variable ec50", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, ec50);
      std::vector<std::vector<local_scalar_t__>> e0_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_e0,
          std::vector<local_scalar_t__>(e0_par_2dim__, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> e0_par_flat__;
        current_statement__ = 2;
        e0_par_flat__ = context__.vals_r("e0_par");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(e0_par, e0_par_flat__[(pos__ - 1)],
              "assigning variable e0_par", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(e0_par);
      std::vector<std::vector<local_scalar_t__>> emax_par =
        std::vector<std::vector<local_scalar_t__>>(n_covlev_emax,
          std::vector<local_scalar_t__>(emax_par_2dim__, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> emax_par_flat__;
        current_statement__ = 3;
        emax_par_flat__ = context__.vals_r("emax_par");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(emax_par, emax_par_flat__[(pos__ - 1)],
              "assigning variable emax_par", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(emax_par);
      std::vector<local_scalar_t__> gamma_par =
        std::vector<local_scalar_t__>(gamma_par_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      gamma_par = context__.vals_r("gamma_par");
      out__.write_free_lb(0, gamma_par);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"ec50", "e0_par", "emax_par",
                "gamma_par"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"mu_logit", "exposure_exp", "gamma", "e0", "emax", "emaxvec",
             "ec50vec", "ec50vec_exp", "e0vec"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    n_covlev_ec50)},
                std::vector<size_t>{static_cast<size_t>(n_covlev_e0),
                  static_cast<size_t>(e0_par_2dim__)},
                std::vector<size_t>{static_cast<size_t>(n_covlev_emax),
                  static_cast<size_t>(emax_par_2dim__)},
                std::vector<size_t>{static_cast<size_t>(gamma_par_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(n_covlev_e0)},
             std::vector<size_t>{static_cast<size_t>(n_covlev_emax)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
      param_names__.emplace_back(std::string() + "ec50" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
        param_names__.emplace_back(std::string() + "e0_par" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
        param_names__.emplace_back(std::string() + "emax_par" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma_par" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_logit" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "exposure_exp" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "gamma");
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        param_names__.emplace_back(std::string() + "e0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        param_names__.emplace_back(std::string() + "emax" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "emaxvec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ec50vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ec50vec_exp" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "e0vec" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_covlev_ec50; ++sym1__) {
      param_names__.emplace_back(std::string() + "ec50" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= e0_par_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_covlev_e0; ++sym2__) {
        param_names__.emplace_back(std::string() + "e0_par" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= emax_par_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_covlev_emax; ++sym2__) {
        param_names__.emplace_back(std::string() + "emax_par" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= gamma_par_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma_par" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_logit" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "exposure_exp" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "gamma");
      for (int sym1__ = 1; sym1__ <= n_covlev_e0; ++sym1__) {
        param_names__.emplace_back(std::string() + "e0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_covlev_emax; ++sym1__) {
        param_names__.emplace_back(std::string() + "emax" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "emaxvec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ec50vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ec50vec_exp" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "e0vec" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"ec50\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_ec50) + "},\"block\":\"parameters\"},{\"name\":\"e0_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_covlev_e0) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(e0_par_2dim__) + ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"emax_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_covlev_emax) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(emax_par_2dim__) + ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"gamma_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(gamma_par_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu_logit\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"exposure_exp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"e0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_e0) + "},\"block\":\"transformed_parameters\"},{\"name\":\"emax\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_emax) + "},\"block\":\"transformed_parameters\"},{\"name\":\"emaxvec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec_exp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"e0vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"ec50\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_ec50) + "},\"block\":\"parameters\"},{\"name\":\"e0_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_covlev_e0) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(e0_par_2dim__) + ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"emax_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_covlev_emax) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(emax_par_2dim__) + ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"gamma_par\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(gamma_par_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu_logit\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"exposure_exp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"e0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_e0) + "},\"block\":\"transformed_parameters\"},{\"name\":\"emax\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_covlev_emax) + "},\"block\":\"transformed_parameters\"},{\"name\":\"emaxvec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"ec50vec_exp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"e0vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((n_covlev_ec50 + (n_covlev_e0 *
      e0_par_2dim__)) + (n_covlev_emax * emax_par_2dim__)) +
      gamma_par_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (((((((((N +
      N) + 1) + n_covlev_e0) + n_covlev_emax) + N) + N) + N) + N));
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((n_covlev_ec50 + (n_covlev_e0 *
      e0_par_2dim__)) + (n_covlev_emax * emax_par_2dim__)) +
      gamma_par_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (((((((((N +
      N) + 1) + n_covlev_e0) + n_covlev_emax) + N) + N) + N) + N));
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_emax_binary_namespace::model_emax_binary;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_emax_binary_namespace::profiles__;
}
#endif
#endif
