% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stap_glmer.R
\name{stap_glmer}
\alias{stap_glmer}
\alias{stap_lmer}
\title{Bayesian spatial-temporal generalized linear models with group-specific terms via Stan}
\usage{
stap_glmer(formula, family = gaussian(), subject_data = NULL,
  distance_data = NULL, time_data = NULL, subject_ID = NULL,
  group_ID = NULL, max_distance = NULL, max_time = NULL, weights,
  offset, contrasts = NULL, ..., prior = normal(),
  prior_intercept = normal(), prior_stap = normal(),
  prior_theta = log_normal(location = 1L, scale = 1L),
  prior_aux = exponential(), prior_covariance = decov(),
  adapt_delta = NULL)

stap_lmer(formula, subject_data = NULL, distance_data = NULL,
  time_data = NULL, subject_ID = NULL, group_ID = NULL,
  max_distance = NULL, max_time = NULL, weights, offset,
  contrasts = NULL, ..., prior = normal(),
  prior_intercept = normal(), prior_stap = normal(),
  prior_theta = log_normal(location = 1L, scale = 1L),
  prior_aux = exponential(), prior_covariance = decov(),
  adapt_delta = NULL)
}
\arguments{
\item{formula}{Same as for \code{\link[lme4]{glmer}}. Note that in-formula
transformations will not be passed to the final design matrix.Covariates that have "scale" in their name are not advised as this text is parsed for in the final model fit.}

\item{family}{Same as for \code{\link[lme4]{glmer}} except limited to gaussian, binomial and poisson}

\item{subject_data}{a data.frame that contains data specific to the subject or subjects on whom the outcome is measured. Must contain one column that has the subject_ID  on which to join the distance and time_data}

\item{distance_data}{a (minimum) three column data.frame that contains (1) an id_key (2) The sap/tap/stap features and (3) the distances between subject with a given id and the built environment feature in column (2), the distance column must be the only column of type "double" and the sap/tap/stap features must be specified in the dataframe exactly as they are in the formula.}

\item{time_data}{same as distance_data except with time that the subject has been exposed to the built environment feature, instead of distance}

\item{subject_ID}{name of column to join on between subject_data and bef_data}

\item{group_ID}{name of column to join on between \code{subject_data} and bef_data that uniquely identifies the groups}

\item{max_distance}{the upper bound on any and all distances included in the model}

\item{max_time}{the upper bound on any and all times included in the model}

\item{weights, offset}{Same as \code{\link[stats]{glm}}.}

\item{contrasts}{Same as \code{\link[stats]{glm}}, but rarely 
specified.}

\item{...}{For \code{stap_glmer}, further arguments passed to 
\code{\link[rstan]{sampling}} (e.g. \code{iter}, \code{chains}, 
\code{cores}, etc.). For \code{stap_lmer} 
 \code{...} should also contain all relevant arguments
to pass to \code{stap_glmer} (except \code{family}).}

\item{prior}{The prior distribution for the regression coefficients. 
\code{prior} should be a call to one of the various functions provided by 
\pkg{rstap} for specifying priors. The subset of these functions that 
can be used for the prior on the coefficients can be grouped into several 
"families":

\tabular{ll}{
  \strong{Family} \tab \strong{Functions} \cr 
  \emph{Student t family} \tab \code{normal}, \code{student_t}, \code{cauchy} \cr 
  \emph{Hierarchical shrinkage family} \tab \code{hs}, \code{hs_plus} \cr 
  \emph{Laplace family} \tab \code{laplace}, \code{lasso} \cr
  \emph{Product normal family} \tab \code{product_normal} \cr
}

See the \link[=priors]{priors help page} for details on the families and 
how to specify the arguments for all of the functions in the table above.
To omit a prior ---i.e., to use a flat (improper) uniform prior---
\code{prior} can be set to \code{NULL}, although this is rarely a good
idea.

\strong{Note:} If \code{prior} is from the Student t
family or Laplace family, and if the \code{autoscale} argument to the 
function used to specify the prior (e.g. \code{\link{normal}}) is left at 
its default and recommended value of \code{TRUE}, then the default or 
user-specified prior scale(s) may be adjusted internally based on the
scales of the predictors. See the \link[=priors]{priors help page} and the
\emph{Prior Distributions} vignette for details on the rescaling and the
\code{\link{prior_summary}} function for a summary of the priors used for a
particular model.}

\item{prior_intercept}{The prior distribution for the intercept. 
\code{prior_intercept} can be a call to \code{normal}, \code{student_t} or 
\code{cauchy}. See the \link[=priors]{priors help page} for details on 
these functions. To omit a prior on the intercept ---i.e., to use a flat
(improper) uniform prior--- \code{prior_intercept} can be set to
\code{NULL}.

\strong{Note:} The prior distribution for the intercept is set so it
applies to the value \emph{when all predictors are centered}. If you prefer
to specify a prior on the intercept without the predictors being
auto-centered, then you have to omit the intercept from the
\code{\link[stats]{formula}} and include a column of ones as a predictor,
in which case some element of \code{prior} specifies the prior on it,
rather than \code{prior_intercept}. Regardless of how
\code{prior_intercept} is specified, the reported \emph{estimates} of the
intercept always correspond to a parameterization without centered
predictors (i.e., same as in \code{glm}).}

\item{prior_theta, prior_stap}{priors for the spatial scale and spatial effect parameters, respectively}

\item{prior_aux}{The prior distribution for the "auxiliary" parameter (if
applicable). The "auxiliary" parameter refers to a different parameter 
depending on the \code{family}. For Gaussian models \code{prior_aux} 
controls \code{"sigma"}, the error 
standard deviation. For negative binomial models \code{prior_aux} controls 
\code{"reciprocal_dispersion"}, which is similar to the 
\code{"size"} parameter of \code{\link[stats]{rnbinom}}:
smaller values of \code{"reciprocal_dispersion"} correspond to 
greater dispersion. For gamma models \code{prior_aux} sets the prior on 
to the \code{"shape"} parameter (see e.g., 
\code{\link[stats]{rgamma}}), and for inverse-Gaussian models it is the 
so-called \code{"lambda"} parameter (which is essentially the reciprocal of
a scale parameter). Binomial and Poisson models do not have auxiliary 
parameters. 

\code{prior_aux} can be a call to \code{exponential} to 
use an exponential distribution, or \code{normal}, \code{student_t} or 
\code{cauchy}, which results in a half-normal, half-t, or half-Cauchy 
prior. See \code{\link{priors}} for details on these functions. To omit a 
prior ---i.e., to use a flat (improper) uniform prior--- set 
\code{prior_aux} to \code{NULL}.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{decov}} for
more information about the default arguments.}

\item{adapt_delta}{See the \link{adapt_delta} help page for details.}
}
\value{
A \link[=stapreg-objects]{stapreg} object is returned 
for \code{stap_glmer, stap_lmer}.
}
\description{
Bayesian inference for stap-glms with group-specific coefficients that have 
unknown covariance matrices with flexible priors.
}
\details{
The \code{stap_glmer} function is similar in syntax to 
  \code{\link[lme4]{glmer}} but rather than performing (restricted) maximum 
  likelihood estimation of generalized linear models, Bayesian estimation is 
  performed via MCMC. The Bayesian model adds priors on the 
  regression coefficients (in the same way as \code{\link{stap_glm}}) and
  priors on the terms of a decomposition of the covariance matrices of the
  group-specific parameters. See \code{\link{priors}} for more information
  about the priors.
  
  The \code{stap_lmer} function is equivalent to \code{stap_glmer} with 
  \code{family = gaussian(link = "identity")}.
}
\examples{
\dontrun{
## subset to only include id, class name and distance variables
distdata <- homog_longitudinal_bef_data[,c("subj_ID","measure_ID","class","dist")]
timedata <- homog_longitudinal_bef_data[,c("subj_ID","measure_ID","class","time")]
## distance or time column must be numeric
timedata$time <- as.numeric(timedata$time) 
fit <- stap_glmer(y_bern ~ centered_income +  sex + centered_age + stap(Coffee_Shop) + (1|subj_ID),
                  family = binomial(link='logit'),
                  subject_data = homog_longitudinal_subject_data,
                  distance_data = distdata,
                  time_data = timedata,
                  subject_ID = 'subj_ID',
                  group_ID = 'measure_ID',
                  prior_intercept = normal(location = 25, scale = 4, autoscale = F),
                  prior = normal(location = 0, scale = 4, autoscale=F),
                  prior_stap = normal(location = 0, scale = 4),
                  prior_theta = list(Coffee_Shop = list(spatial = log_normal(location = 1,
                                                                             scale = 1),
                                                         temporal = log_normal(location = 1,
                                                                               scale = 1))),
                  max_distance = 3, max_time = 50,
                  chains = 4, refresh = -1, verbose = FALSE, 
                  iter = 1E3, cores = 1)
}
}
\references{
Gelman, A. and Hill, J. (2007). \emph{Data Analysis Using
  Regression and Multilevel/Hierarchical Models.} Cambridge University Press,
  Cambridge, UK.

Muth, C., Oravecz, Z., and Gabry, J. (2018)
User-friendly Bayesian regression modeling: A tutorial with rstanarm and shinystan.
\emph{The Quantitative Methods for Psychology}. 14(2), 99--119.
\url{https://www.tqmp.org/RegularArticles/vol14-2/p099/p099.pdf}
}
\seealso{
\code{\link{stapreg-methods}} and 
\code{\link[lme4]{glmer}}.

The Longituinal \href{https://biostatistics4socialimpact.github.io/rstap/articles/longitudinal-I.html}{Vignette} for \code{stap_glmer} 
and the \href{http://arxiv.org/abs/1812.10208}{preprint} article available through arXiv.
}
