% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{start_annotation_simple}
\alias{start_annotation_simple}
\title{Start simple annotation}
\usage{
start_annotation_simple(
  events,
  layers,
  coords = c("lng", "lat"),
  date = "date"
)
}
\arguments{
\item{events}{A data.frame for on the fly annotation}

\item{layers}{A list of parameters or vector of codes, of the layers, see the examples below.}

\item{coords}{A vector of length 2 containing column names for record longitudes, and latitudes.}

\item{date}{Column name for record dates, dates must take the format YYYY-MM-DD}
}
\value{
Input data.frame with values from the annotation appended, in addition to unique identifier field event_id.
\itemize{
 \item event_id: A unique identifier for each occurrence
 \item product: Product used for annotation
 \item variable: Variable used for annotation
 \item s_buff: Spatial buffer in meters applied to occurrence
 \item t_buff: Temporal buffer in days applied to occurrence
 \item value: Annotated value of occurrence from requested layer (mean within buffer)
 \item stdev: Standard deviation of values within buffer
 \item valid_pixel_count: Number of pixels within buffered area'
}
}
\description{
Submit a dataframe for on-the-fly annotation.
Does not require login - for use for small numbers of records and pilot jobs
}
\examples{
\dontrun{
events <- data.frame(
   event_id = as.character(1:2),
   lng = c(-4, 24),
   lat = c(10, 10),
   date = '2015-01-01'
)
layers <- 'landsat8-evi-100-16'
start_annotation_simple(events, layers)
}
}
