/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.io.Serializable;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DerivedNominalValue;
import org.vikamine.kernel.data.DescribableDataObject;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.util.VKMUtil;
import org.w3c.dom.Element;

public abstract class Value
extends DescribableDataObject {
    public static final String CONST_UNKNOWN = "MaU";
    public static final int CONST_NUM_UNKNOWN = -1;
    public static final String CONST_MISSING_STRING = "*Missing*";
    protected static final double MISSING_VALUE = Double.NaN;

    public static CustomDiscretizedValue createCustomDiscretizedValue(Attribute discretizedAtt, double min, double max) {
        return new CustomDiscretizedValue(discretizedAtt, min, max);
    }

    public static String createMultiValueDefaultName(Collection<SingleValue> values) {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        Iterator<SingleValue> iter = values.iterator();
        while (iter.hasNext()) {
            SingleValue sNValue = iter.next();
            buff.append(sNValue.getId());
            if (!iter.hasNext()) continue;
            buff.append("; ");
        }
        buff.append("}");
        return buff.toString();
    }

    protected static boolean equalValues(double value1, double value2) {
        return Value.equalValues(value1, value2, false);
    }

    public static boolean equalValues(double value1, double value2, boolean withTolerance) {
        if (Double.isNaN(value1)) {
            return Double.isNaN(value2);
        }
        if (Double.isNaN(value2)) {
            return false;
        }
        if (withTolerance) {
            return VKMUtil.eq(value1, value2);
        }
        return value1 == value2;
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static boolean isUnknownValue(String value) {
        return CONST_UNKNOWN.equals(value);
    }

    public static boolean isUnknownValue(Value val) {
        return val.getId().equals(CONST_UNKNOWN);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public static Value missingValue(Attribute attribute) {
        return new MissingValue(attribute);
    }

    public abstract Attribute getAttribute();

    public abstract boolean isMissingValue();

    public boolean isDefaultValue() {
        return false;
    }

    public abstract boolean isValueContainedInInstance(DataRecord var1);

    public Value(String id) {
        super(id);
    }

    public static class CustomDiscretizedValue
    extends Value {
        private Attribute attribute;
        private final Attribute discretizedAtt;
        protected boolean leftOpen = true;
        protected double max = Double.POSITIVE_INFINITY;
        protected double min = Double.NEGATIVE_INFINITY;
        protected boolean rightOpen = false;

        private CustomDiscretizedValue(Attribute discretizedAtt, double minimum, double maximum) {
            super(String.valueOf(discretizedAtt.getId()) + ":" + VKMUtil.getFormattedDoubleString(minimum) + "-" + VKMUtil.getFormattedDoubleString(maximum));
            this.discretizedAtt = discretizedAtt;
            this.setMin(minimum);
            this.setMax(maximum);
        }

        @Override
        public int computeCachedHashCode() {
            long tmp = Double.doubleToLongBits(this.max);
            int code = (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.min);
            int code2 = (int)(tmp ^ tmp >>> 32);
            return code ^ code2;
        }

        public boolean contains(double value) {
            if (Double.isNaN(value)) {
                return Double.isNaN(this.getMin());
            }
            if (this.getMin() < value && value < this.getMax()) {
                return true;
            }
            if (value == this.getMin() && !this.isLeftOpen()) {
                return true;
            }
            return value == this.getMax() && !this.isRightOpen();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CustomDiscretizedValue d = (CustomDiscretizedValue)object;
            if (!CustomDiscretizedValue.equalValues(this.getMin(), d.getMin())) {
                return false;
            }
            return CustomDiscretizedValue.equalValues(this.getMax(), d.getMax());
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public String getDescription() {
            if (Double.isNaN(this.getMin())) {
                assert (Double.isNaN(this.getMax()));
                return Value.CONST_MISSING_STRING;
            }
            if (CustomDiscretizedValue.equalValues(this.getMin(), this.getMax())) {
                return String.valueOf(this.getMin());
            }
            if (Double.isInfinite(this.getMin())) {
                return "<= " + this.getMax();
            }
            if (Double.isInfinite(this.getMax())) {
                return "> " + this.getMin();
            }
            return String.valueOf(this.getMin()) + " - " + this.getMax();
        }

        @Override
        public String getDescription(Describer d) {
            return d.createDescription(this);
        }

        public Attribute getDiscretizedAttribute() {
            return this.discretizedAtt;
        }

        @Override
        public String getId() {
            StringBuffer valStrBuffer = new StringBuffer();
            valStrBuffer.append(this.attribute);
            valStrBuffer.append(this.leftOpen ? "(" : "[");
            valStrBuffer.append(this.min);
            valStrBuffer.append(",");
            valStrBuffer.append(this.max);
            valStrBuffer.append(this.rightOpen ? ")" : "]");
            return valStrBuffer.toString();
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        protected double getValue(DataRecord instance) {
            return instance.getValue(this.discretizedAtt);
        }

        public boolean isLeftOpen() {
            return this.leftOpen;
        }

        @Override
        public boolean isMissingValue() {
            return false;
        }

        public boolean isRightOpen() {
            return this.rightOpen;
        }

        @Override
        public boolean isValueContainedInInstance(DataRecord instance) {
            return this.contains(this.getValue(instance));
        }

        public void setAttribute(Attribute att) {
            this.attribute = att;
        }

        public void setLeftOpen(boolean leftOpen) {
            this.leftOpen = leftOpen;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public void setRightOpen(boolean rightOpen) {
            this.rightOpen = rightOpen;
        }

        public String toString() {
            return this.getId();
        }
    }

    public static class MissingValue
    extends Value {
        private final Attribute attribute;

        MissingValue(Attribute att) {
            super(Value.CONST_MISSING_STRING);
            if (att == null) {
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "MissingValue", new IllegalArgumentException("Attribute is null!"));
            }
            this.attribute = att;
        }

        @Override
        public int computeCachedHashCode() {
            return this.attribute.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MissingValue that = (MissingValue)obj;
            return this.attribute.equals(that.attribute);
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public String getDescription() {
            return Value.CONST_MISSING_STRING;
        }

        @Override
        public String getDescription(Describer d) {
            return d.createDescription(this);
        }

        @Override
        public String getId() {
            return String.valueOf(this.attribute.getId()) + "aMissing";
        }

        @Override
        public boolean isMissingValue() {
            return true;
        }

        @Override
        public boolean isValueContainedInInstance(DataRecord instance) {
            return instance.isMissing(this.attribute);
        }

        public String toString() {
            return this.getId();
        }
    }

    public static class UncompleteNominalValue
    extends Value {
        private final DerivedNominalValue value;
        private final Element condition;

        public UncompleteNominalValue(DerivedNominalValue val, Element condition) {
            super(val.getId());
            this.value = val;
            this.condition = condition;
        }

        @Override
        public Attribute getAttribute() {
            return null;
        }

        public Element getCondition() {
            return this.condition;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getDescription(Describer d) {
            return d.createDescription(this);
        }

        @Override
        public String getId() {
            return null;
        }

        public DerivedNominalValue getValue() {
            return this.value;
        }

        @Override
        public boolean isMissingValue() {
            return false;
        }

        @Override
        public boolean isValueContainedInInstance(DataRecord instance) {
            return false;
        }

        @Override
        protected int computeCachedHashCode() {
            return this.getValue().getId().hashCode();
        }
    }

    public static class ValueComparator
    implements Comparator<Value>,
    Serializable {
        private static final long serialVersionUID = -4192351066855635055L;

        @Override
        public int compare(Value val1, Value val2) {
            return Collator.getInstance().compare(val1.getId(), val2.getId());
        }
    }
}

