/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.DefaultAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.converters.CaseObjectConverterUtils;
import org.vikamine.kernel.data.creators.OntologyCreator;

public abstract class AbstractOntologyCreator
implements OntologyCreator {
    protected DataRecordSet dataset;

    protected void createIDAttribute() {
        if (!this.isIDAttributePresent()) {
            Attribute idAttribute = AttributeBuilder.createEmptyIDAttribute();
            this.dataset.insertAttributeAt(idAttribute, 0);
            int i = 0;
            while (i < this.dataset.getNumInstances()) {
                this.dataset.get(i).setValue(this.dataset.getAttribute(0), CaseObjectConverterUtils.createIdValueFromCaseId("Case" + Integer.valueOf(i + 1).toString()));
                ++i;
            }
        }
    }

    protected void copyAttributesToOntology(Ontology ontology) {
        Iterator<Attribute> iter = this.dataset.attributeIterator();
        while (iter.hasNext()) {
            Attribute att = iter.next();
            if (att.getDescription() == null) {
                att.setDescription(att.getId());
            }
            ontology.addAttribute(att);
        }
    }

    private boolean isIDAttributePresent() {
        int i = 0;
        while (i < this.dataset.getNumAttributes()) {
            Attribute att = this.dataset.getAttribute(i);
            if (DefaultAttribute.isIDAttribute(att)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static class AttributeNameComparatorAscending
    implements Comparator<Attribute> {
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(Attribute a1, Attribute a2) {
            return this.collator.compare(a1.getId(), a2.getId());
        }
    }
}

