/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.lang.ref.WeakReference;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.SupervisedBinaryDiscretizer;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class EntropyDiscretizer
extends SupervisedBinaryDiscretizer {
    private static final String NAME = "Entropy Discretizer";
    private static final String SEGCOUNT = "segcount";
    static final double LOG2 = Math.log(2.0);

    static double entropy(int negatives, int positives, int totalCount) {
        return (negatives > 0 ? -EntropyDiscretizer.entropyAddand(negatives, totalCount) : 0.0) - (positives > 0 ? EntropyDiscretizer.entropyAddand(positives, totalCount) : 0.0);
    }

    private static double entropyAddand(int classCount, int totalCount) {
        double frequency = (double)classCount / (double)totalCount;
        return frequency * (Math.log(frequency) / LOG2);
    }

    static double cieAddand(int sizeCut, double entropy) {
        double weight = sizeCut;
        return weight * entropy;
    }

    public EntropyDiscretizer(SGTarget target) {
        super(target);
    }

    public EntropyDiscretizer(DataView population, NumericAttribute na, int segmentsCount, SGTarget target) {
        super(target);
        this.setPopulation(population);
        this.setAttribute(na);
        this.setSegmentsCount(segmentsCount);
    }

    public EntropyDiscretizer(String[] args) {
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(SEGCOUNT)) {
                this.segmentsCount = Integer.parseInt(arg[1].trim());
            }
            ++i;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    SupervisedBinaryDiscretizer.BinaryPartition makeBinaryPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
        EntropyPartition ep = new EntropyPartition();
        if (firstBlock.upperBoundary == null) {
            return ep;
        }
        ep.findBestCutpoint(firstBlock.upperBoundary, null, null, lastBlock, 0.0);
        int i = 2;
        while (i < this.segmentsCount) {
            EntropyPartition x = new EntropyPartition();
            ep.insertPartition(firstBlock.upperBoundary, null, null, lastBlock, 0.0, x);
            x.updateCieParts();
            ++i;
        }
        return ep;
    }

    private static final class EntropyPartition
    extends SupervisedBinaryDiscretizer.BinaryPartition {
        private WeakReference<EntropyPartition> parent;
        private double ciePartsLower;
        private double ciePartsUpper;
        private double classInformationEntropy = Double.POSITIVE_INFINITY;

        private EntropyPartition() {
            this.isAccepted = true;
        }

        private void insertPartition(SupervisedBinaryDiscretizer.BoundaryPoint start, SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, double cieParts, EntropyPartition partition) {
            double ciePartsForCut = cieParts + this.ciePartsUpper;
            if (this.lowerPartition == null) {
                if (partition.findBestCutpoint(start, lowerBoundary, this.cutPoint, lastBlock, ciePartsForCut)) {
                    this.lowerPartition = partition;
                    partition.switchParent(this);
                }
            } else {
                ((EntropyPartition)this.lowerPartition).insertPartition(start, lowerBoundary, this.cutPoint, lastBlock, ciePartsForCut, partition);
            }
            ciePartsForCut = cieParts + this.ciePartsLower;
            if (this.upperPartition == null) {
                if (partition.findBestCutpoint(this.cutPoint.nextCutPoint(), this.cutPoint, upperBoundary, lastBlock, ciePartsForCut)) {
                    this.upperPartition = partition;
                    partition.switchParent(this);
                }
            } else {
                ((EntropyPartition)this.upperPartition).insertPartition(this.cutPoint.nextCutPoint(), this.cutPoint, upperBoundary, lastBlock, ciePartsForCut, partition);
            }
        }

        private boolean findBestCutpoint(SupervisedBinaryDiscretizer.BoundaryPoint start, SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, double cieParts) {
            boolean found = false;
            SupervisedBinaryDiscretizer.BoundaryPoint candidate = start;
            while (candidate != upperBoundary) {
                double cieAddandUpper;
                int negativesLower = candidate.sumNegativesLowerCut(lowerBoundary);
                int positivesLower = candidate.sumPositivesLowerCut(lowerBoundary);
                int negativesUpper = candidate.sumNegativesUpperCut(upperBoundary, lastBlock);
                int positivesUpper = candidate.sumPositivesUpperCut(upperBoundary, lastBlock);
                int sizeLowerCut = negativesLower + positivesLower;
                int sizeUpperCut = negativesUpper + positivesUpper;
                double entropyLower = EntropyDiscretizer.entropy(negativesLower, positivesLower, sizeLowerCut);
                double entropyUpper = EntropyDiscretizer.entropy(negativesUpper, positivesUpper, sizeUpperCut);
                double cieAddandLower = EntropyDiscretizer.cieAddand(sizeLowerCut, entropyLower);
                double classInformationEntropy = cieParts + cieAddandLower + (cieAddandUpper = EntropyDiscretizer.cieAddand(sizeUpperCut, entropyUpper));
                if (classInformationEntropy < this.classInformationEntropy) {
                    this.classInformationEntropy = classInformationEntropy;
                    this.cutPoint = candidate;
                    this.ciePartsLower = cieAddandLower;
                    this.ciePartsUpper = cieAddandUpper;
                    found = true;
                }
                candidate = candidate.nextCutPoint();
            }
            return found;
        }

        private void clearChild(EntropyPartition child) {
            if (this.lowerPartition == child) {
                this.lowerPartition = null;
            } else {
                this.upperPartition = null;
            }
        }

        private void switchParent(EntropyPartition newParent) {
            if (this.parent != null) {
                ((EntropyPartition)this.parent.get()).clearChild(this);
            }
            this.parent = new WeakReference<EntropyPartition>(newParent);
        }

        private double cieParts() {
            return this.ciePartsLower + this.ciePartsUpper;
        }

        private void updateCieParts() {
            if (this.parent == null) {
                return;
            }
            ((EntropyPartition)this.parent.get()).updateCieParts(this);
        }

        private void updateCieParts(EntropyPartition child) {
            if (this.lowerPartition == child) {
                this.ciePartsLower = child.cieParts();
            } else {
                this.ciePartsUpper = child.cieParts();
            }
            if (this.parent == null) {
                return;
            }
            ((EntropyPartition)this.parent.get()).updateCieParts(this);
        }
    }
}

