/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.Collections;
import java.util.Set;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormulaNumber
implements FormulaNumberElement {
    private Double value;

    public FormulaNumber() {
        this(new Double(0.0));
    }

    public FormulaNumber(Double value) {
        this.setValue(value);
    }

    @Override
    public synchronized Double eval(EvaluationData data) {
        return this.getValue();
    }

    public String toString() {
        if (this.getValue() == null) {
            return "";
        }
        return this.trim(this.getValue());
    }

    private String trim(Object trimValue) {
        int digits = 3;
        String text = trimValue.toString();
        int dot = text.indexOf(".");
        if (dot != -1) {
            text = text.substring(0, Math.min(text.length(), dot + 1 + 3));
        }
        return text;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public Set getAttributes() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = doc.createElement("formula");
        elem.setAttribute("symbol", "number");
        elem.setAttribute("value", String.valueOf(this.value));
        return elem;
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    @Override
    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.value.equals(((FormulaNumber)other).value);
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    @Override
    public int computeHashCode() {
        return this.value.hashCode();
    }
}

