% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cg_legislators.R
\name{cg_legislators}
\alias{cg_legislators}
\title{Search for legislators.}
\usage{
cg_legislators(title = NULL, first_name = NULL, middle_name = NULL,
  last_name = NULL, name_suffix = NULL, nickname = NULL, party = NULL,
  state = NULL, state_name = NULL, state_rank = NULL, district = NULL,
  in_office = NULL, chamber = NULL, gender = NULL, phone = NULL,
  fax = NULL, office = NULL, website = NULL, contact_form = NULL,
  email = NULL, congress_office = NULL, bioguide_id = NULL,
  ocd_id = NULL, thomas_id = NULL, lis_id = NULL, crp_id = NULL,
  icpsr_id = NULL, votesmart_id = NULL, fec_ids = NULL,
  govtrack_id = NULL, congresspedia_url = NULL, twitter_id = NULL,
  youtube_id = NULL, facebook_id = NULL, senate_class = NULL,
  term_start = NULL, term_end = NULL, birthday = NULL, latitude = NULL,
  longitude = NULL, zip = NULL, query = NULL, fields = NULL, page = 1,
  per_page = 20, order = NULL, key = NULL, as = "table", ...)
}
\arguments{
\item{title}{Title held by this legislator, either Sen or Rep}

\item{first_name}{Legislator's first name}

\item{middle_name}{Legislator's middle name or initial}

\item{last_name}{Legislator's last name}

\item{name_suffix}{Legislator's suffix (Jr., III, etc.)}

\item{nickname}{Preferred nickname of legislator (if any)}

\item{party}{Legislator's political party (D, I, or R)}

\item{state}{two letter abbreviation of legislator's state}

\item{state_name}{The full state name of the state this member represents.}

\item{state_rank}{(Senate only) The seniority of that Senator for that state. "junior" or
"senior".}

\item{district}{If legislator is a representative, their district. 0 is used
for At-Large districts}

\item{in_office}{1 if legislator is currently serving, 0 if legislator is no
longer in office due to defeat/resignation/death/etc.}

\item{chamber}{Chamber the member is in. One of "senate" or "house".}

\item{gender}{M or F}

\item{phone}{Congressional office phone number}

\item{fax}{Congressional office fax number}

\item{office}{Office number for the member's DC office.}

\item{website}{URL of Congressional website}

\item{contact_form}{URL of web contact form}

\item{email}{Legislator's email address (if known)}

\item{congress_office}{Legislator's Washington DC Office Address}

\item{bioguide_id}{Legislator ID assigned by
http://bioguide.congress.gov/biosearch/biosearch.asp Congressional
Biographical Directory (also used by Washington Post/NY Times)}

\item{ocd_id}{Identifier for this member across all countries and levels of government, as
defined by the Open Civic Data project.}

\item{thomas_id}{Identifier for this member as it appears on THOMAS.gov and Congress.gov.}

\item{lis_id}{Identifier for this member as it appears on some of Congress' data systems (namely
Senate votes).}

\item{crp_id}{Identifier for this member as it appears on Center for Responsive
Politics OpenSecrets (http://opensecrets.org)}

\item{icpsr_id}{Identifier for this member as it is maintained by the Inter-university
Consortium for Political and Social Research.}

\item{votesmart_id}{Legislator ID assigned by http://votesmart.org Project
Vote Smart}

\item{fec_ids}{http://fec.gov Federal Election Commission ID}

\item{govtrack_id}{ID assigned by http://govtrack.us Govtrack.us}

\item{congresspedia_url}{URL of Legislator's entry on http://congresspedia.org
Congresspedia}

\item{twitter_id}{The Twitter username for a member's official legislative account. This field
does not contain the handles of campaign accounts.}

\item{youtube_id}{The YouTube username or channel for a member's official legislative account.
This field does not contain the handles of campaign accounts. A few legislators use YouTube
"channels" instead of regular accounts. These channels will be of the form channel/[id].}

\item{facebook_id}{The Facebook username or ID for a member's official legislative Facebook
presence. ID numbers and usernames can be used interchangeably in Facebook's URLs and APIs.
The referenced account may be either a Facebook Page or a user account.}

\item{senate_class}{for senators I, II, or III depending on the Senator's
election term}

\item{term_start}{The date a member's current term started.}

\item{term_end}{The date a member's current term will end.}

\item{birthday}{YYYY-MM-DD formatted birth date}

\item{latitude}{latitude of coordinate}

\item{longitude}{longitude of coordinate}

\item{zip}{zip code to search}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from environment variable from .Renviron or
from an option from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\value{
List of output fields.
}
\description{
Search for legislators.
}
\details{
Currently the Sunlight Labs API provides two methods for obtaining
   information about legislators: sll_cg_getlegislator and
   sll_cg_getlegislatorlist. Both of these methods operate in essentially
   the same way, the main difference being that sll_cg_getlegislator returns
   a single legislator (or an error if the query would have resulted in
   multiple legislators) and sll_cg_getlegislatorlist returns a list of
   legislators (a list of size one is allowed). In other words,
   sll_cg_getlegislator is purely a convenience method to avoid dealing with
   a list of values when only one value is needed.

All social media account values can be turned into URLs by preceding them with the domain name
of the service in question:
\itemize{
 \item http://twitter.com/[username]
 \item http://youtube.com/[username or channel ID]
 \item http://facebook.com/[username or ID]
}

\bold{Note about zip codes from Sunlight Foundation (a direct quote):} "A zip code may intersect
multiple Congressional districts, so locating by
zip may return multiple representatives, and possibly more than 2 senators if the zip code
crosses state borders. In general, we recommend against using zip codes to look up members of
Congress. For one, it's imprecise: a zip code can intersect multiple congressional districts.
More importantly, zip codes are not shapes. They are lines (delivery routes), and treating them
as shapes leads to inaccuracies."
}
\examples{
\dontrun{
cg_legislators(last_name = 'Pelosi')
cg_legislators(party = 'D')
cg_legislators(facebook_id = 'mitchmcconnell')
cg_legislators(latitude = 35.778788, longitude = -78.787805)
cg_legislators(zip = 77006)

# Output a list
cg_legislators(last_name = 'Pelosi', as='list')
# Output an httr response object, for debugging purposes
cg_legislators(last_name = 'Pelosi', as='response')

# Pagination
cg_legislators(party = 'D', per_page=2)

# Curl debugging
library('httr')
cg_legislators(party = 'D', config=verbose())
cg_legislators(party = 'D', config=timeout(0.1))

# most parameters are vectorized, pass in more than one value
cg_legislators(party = c('D', 'R'))
}
}

