% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{fsimport.serialise}
\alias{fsimport.serialise}
\title{'Freesurfer' Import (Serialise)}
\usage{
fsimport.serialise(subjectDir, serialisationLocation,
  fields = c("lh.cortical.thickness", "rh.cortical.thickness",
  "lh.cortical.volume", "rh.cortical.volume", "lh.cortical.thickness.std",
  "rh.cortical.thickness.std", "lh.cortical.area", "rh.cortical.area",
  "lh.subcortical", "rh.subcortical", "lh.hippocampal", "rh.hippocampal"),
  verbose)
}
\arguments{
\item{subjectDir}{The directory containing the subject subdirectories}

\item{serialisationLocation}{The location where the serialised file is saved to and loaded from}

\item{fields}{The field groups to use, see fsimport() for more details}

\item{verbose}{Whether to log the 'Freesurfer' scripts to the R console}
}
\value{
The subject data processed from 'Freesurfer'
}
\description{
Calls fsimport() and once that data frame is created it is serialised to the file specified by serialisationLocation. However, if this file already exists when the function is run, then it will unserialise the file instead of calling fsimport(). This saves constant running of 'Freesurfer' scripts when running code thus saving execution time for code to run.
}
\examples{
\dontrun{
setfshome("/Applications/freesurfer")
fsimport.serialise("~/Subjects", serialisationLocation = "~/data.rds")
}
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
