% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_write.R
\name{scto_write}
\alias{scto_write}
\title{Write data to a SurveyCTO server}
\usage{
scto_write(
  auth,
  data,
  dataset_id,
  dataset_title = dataset_id,
  append = FALSE,
  fill = FALSE
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{data}{\code{data.frame} to upload.}

\item{dataset_id}{String indicating ID of existing dataset.}

\item{dataset_title}{String indicating title of dataset. Will replace the
existing title, regardless of \code{append}.}

\item{append}{Logical indicating whether to append or replace the dataset.}

\item{fill}{Logical indicating whether to implicitly fill missing columns
with \code{NA}s, i.e., whether to allow a mismatch between columns of the
existing dataset and columns of \code{data}. Only used if \code{append} is \code{TRUE}.}
}
\value{
A list with elements:
\itemize{
\item \code{data_old}: A \code{data.table} of the previous version of the dataset.
\item \code{response}: An object of class \code{\link[httr:response]{httr::response()}} from the POST request.
}
}
\description{
This function updates an existing dataset using a web POST request, as
uploading data is not officially supported by the SurveyCTO API.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
r = scto_write(auth, data, 'my_dataset', 'My Dataset')
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_meta]{scto_meta()}}, \code{\link[=scto_read]{scto_read()}},
\code{\link[=scto_get_attachments]{scto_get_attachments()}}
}
