% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_login.R
\name{rt_login}
\alias{rt_login}
\title{Log in to RT}
\usage{
rt_login(
  user = Sys.getenv("RT_USER"),
  password = Sys.getenv("RT_PASSWORD"),
  ...
)
}
\arguments{
\item{user}{(character) Your username.}

\item{password}{(character) Your password.}

\item{...}{Other arguments passed to \code{\link{rt_POST}}}
}
\value{
Either \code{TRUE}, invisibly, if logged in, or throws an error.
}
\description{
Use this to log into RT at the start of your session. Once you call this
function and successfully log in, calls of other functions within this
package will re-use your login information automatically.
}
\details{
The value of \code{rt_base_url} should be the same address you use in your
web browser to log into RT (i.e., the address of the log in page).
}
\examples{
\dontrun{
# You can setup the location of your RT installation and the values for
# your credentials as environmental variables
Sys.setenv("RT_USER" = "user",
           "RT_PASSWORD" = "password",
           "RT_BASE_URL" = "https://demo.bestpractical.com")

# And then log in directly like
rt_login()

# You can also skip setting `RT_USER` and `RT_PASSWORD` and specify them
# directly
rt_login("user", "password")
# Note that you still need to set `RT_BASE_URL`
}
}
