% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{summarize_row_groups}
\alias{summarize_row_groups}
\title{Add a content row of summary counts}
\usage{
summarize_row_groups(
  lyt,
  var = "",
  label_fstr = "\%s",
  format = "xx (xx.x\%)",
  cfun = NULL,
  indent_mod = 0L,
  extra_args = list()
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{label_fstr}{string. An sprintf style format string containing. For non-comparison splits, it can contain  up to one \code{"\%s"} which takes the current split value and generates the row/column label. Comparison-based splits it can contain up to two \code{"\%s"}.}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{cfun}{list/function/NULL. tabulation function(s) for creating content rows. Must accept \code{x} or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional arguments accepted by analysis functions. See \code{\link{analyze}}.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Add a content row of summary counts
}
\details{
If \code{format} expects 2 values (i.e. \code{xx} appears twice in the format string, then both raw and percent of
column total counts are calculated. Otherwise only raw counts are used.

\code{cfun} must accept \code{df} as its first argument and will receive the subset \code{data.frame} corresponding
with the row- and column-splitting for the cell being calculated. Must accept \code{labelstr} as the second
parameter, which accepts the \code{label} of the level of the parent split currently being summarized. Optionally can
accept \code{.N_col} or \code{.N_total} (see \code{\link{analyze}}).
}
\examples{

DM2 <- subset(DM, COUNTRY \%in\% c("USA", "CAN", "CHN"))

l <- basic_table() \%>\% split_cols_by("ARM") \%>\%
    split_rows_by("COUNTRY", split_fun = drop_split_levels) \%>\%
    summarize_row_groups(label_fstr = "\%s (n)") \%>\%
    analyze("AGE", afun = list_wrap_x(summary) , format = "xx.xx")
l

tbl <- build_table(l, DM2)

tbl

row_paths_summary(tbl) # summary count is a content table


## use a cfun and extra_args to customize summarization
## behavior
sfun <- function(x, labelstr, trim) {
    in_rows(
        c(mean(x, trim = trim), trim),
        .formats = "xx.x (xx.x\%)",
        .labels = sprintf("\%s (Trimmed mean and trim \%\%)",
                              labelstr)
    )
}

l2 <- basic_table() \%>\% split_cols_by("ARM") \%>\%
    split_rows_by("COUNTRY", split_fun = drop_split_levels) \%>\%
    add_colcounts() \%>\%
    summarize_row_groups("AGE", cfun = sfun,
                         extra_args = list(trim = .2)) \%>\%
    analyze("AGE", afun = list_wrap_x(summary) , format = "xx.xx") \%>\%
    append_topleft(c("Country", "  Age"))

tbl2 <- build_table(l2, DM2)
tbl2

}
\author{
Gabriel Becker
}
