% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rtables_aligns}
\alias{rtables_aligns}
\title{Alignment utils}
\usage{
rtables_aligns()
}
\value{
a vector of alignments currently supported.
}
\description{
Currently supported cell value alignments. These values
may be used to set content alignment (\code{align} in \code{\link[=rcell]{rcell()}} or \code{.aligns}
in \code{\link[=in_rows]{in_rows()}}).
}
\examples{
# See the alignments available in rtables
rtables_aligns()

# Right alignment with align in rcell()
lyt <- basic_table() \%>\%
  analyze("Species", function(x) in_rows(left = rcell("r", align = "right")))

tbl <- build_table(lyt, iris)
tbl

# Set multiple alignments using character vectors with .aligns in in_rows()
lyt2 <- basic_table() \%>\%
  analyze("Species", function(x) {
    in_rows(
      left = rcell("l"),
      right = rcell("r"),
      .aligns = c("left", "right")
    )
  })

tbl2 <- build_table(lyt2, iris)
tbl2

# Clinical data example:
lyt3 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
  analyze(c("AGE"), function(x) {
    in_rows(
      "mean" = rcell(mean(x), align = "right"),
      "sd" = rcell(sd(x), align = "left"), .formats = c("xx.x")
    )
  }, show_labels = "visible", na_str = "NE")

tbl3 <- build_table(lyt3, ex_adsl)
tbl3

}
\seealso{
\code{\link[=in_rows]{in_rows()}}, \code{\link[=rcell]{rcell()}}
}
