% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{add_colcounts}
\alias{add_colcounts}
\title{Add the column population counts to the header}
\usage{
add_colcounts(lyt, format = "(N=xx)")
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{format}{\code{FormatSpec}. Format associated with this split. Formats can be
declared via strings (\code{"xx.x"}) or function. In cases such as
\code{analyze} calls, they can character vectors or lists of functions.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further
layouting functions, and to \code{build_table}.
}
\description{
Add the data derived column counts.
}
\details{
It is often the case that the the column counts derived from the
input data to \code{build_table} is not representative of the population counts.
For example, if events are counted in the table and the header should
display the number of subjects and not the total number of events. In that
case use the \code{col_count} argument in \code{build_table} to control the counts
displayed in the table header.
}
\examples{
lyt <- basic_table() \%>\% split_cols_by("ARM") \%>\%
    add_colcounts() \%>\%
    split_rows_by("RACE", split_fun = drop_split_levels) \%>\%
    analyze("AGE", afun = function(x) list(min = min(x), max = max(x)))
lyt

tbl <- build_table(lyt, DM)
tbl

}
\author{
Gabriel Becker
}
