% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compare_tables.R
\name{all_zero_or_na}
\alias{all_zero_or_na}
\alias{all_zero}
\alias{content_all_zeros_nas}
\alias{prune_empty_level}
\alias{prune_zeros_only}
\alias{low_obs_pruner}
\title{Trimming and Pruning Criteria}
\usage{
all_zero_or_na(tr)

all_zero(tr)

content_all_zeros_nas(tt, criteria = all_zero_or_na)

prune_empty_level(tt)

prune_zeros_only(tt)

low_obs_pruner(min, type = c("sum", "mean"))
}
\arguments{
\item{tr}{\code{TableRow} (or related class). A \code{TableRow} object representing a
single row within a populated table.}

\item{tt}{\code{TableTree} (or related class). A \code{TableTree} object representing a
populated table.}

\item{criteria}{function. Function which takes a \code{TableRow} object and returns
\code{TRUE} if that row should be removed. Defaults to
\code{\link{all_zero_or_na}}}

\item{min}{numeric(1). (\code{low_obs_pruner} only). Minimum aggregate count value.
Subtables whose combined/average count are below this threshold will be
pruned}

\item{type}{character(1). How count values should be aggregated. Must be
\code{"sum"} (the default) or \code{"mean"}}
}
\value{
A logical value indicating whether \code{tr} should be included
(\code{TRUE}) or pruned (\code{FALSE}) during pruning.
}
\description{
Criteria functions (and constructors thereof) for trimming and pruning
tables.
}
\details{
\code{all_zero_or_na} returns \code{TRUE} (and thus indicates
trimming/pruning) for any \emph{non-\code{LabelRow}} \code{TableRow} which contain
only any mix of \code{NA} (including \code{NaN}), \code{0}, \code{Inf} and
\code{-Inf} values.

\code{all_zero} returns \code{TRUE} for any non-Label row which
contains only (non-missing) zero values.

\code{content_all_zeros_nas} Prunes a subtable if a) it has a
content table with exactly one row in it, and b) \code{all_zero_or_na}
returns \code{TRUE} for that single content row. In practice, when the
default summary/content function is used, this represents pruning any
subtable which corresponds to an empty set of the input data (e.g., because
a factor variable was used in \code{\link{split_rows_by}} but not all
levels were present in the data).

\code{prune_empty_level} combines \code{all_zero_or_na} behavior for
\code{TableRow} objects, \code{content_all_zeros_nas} on
\code{content_table(tt)} for \code{TableTree} objects, and an additional
check that returns \code{TRUE} if the \code{tt} has no children.

\code{prune_zeros_only} behaves as \code{prune_empty_level} does,
except that like \code{all_zero} it prunes only in the case of all
non-missing zero values.

\code{low_obs_pruner} is a \emph{constructor function} which, when
called, returns a pruning criteria function which will prune on content
rows by comparing sum or mean (dictated by \code{type}) of the count
portions of the cell values (defined as the first value per cell regardless
of how many values per cell there are) against \code{min}.
}
\examples{
adsl <- ex_adsl
levels(adsl$SEX) <- c(levels(ex_adsl$SEX), "OTHER")
adsl$AGE[adsl$SEX == "UNDIFFERENTIATED"] <- 0
adsl$BMRKR1 <- 0

tbl_to_prune <- basic_table() \%>\%
    analyze("BMRKR1") \%>\%
    split_cols_by("ARM") \%>\% 
    split_rows_by("SEX") \%>\% 
    summarize_row_groups() \%>\%
    split_rows_by("STRATA1") \%>\%
    summarize_row_groups() \%>\%
    analyze("AGE") \%>\%
    build_table(adsl)

tbl_to_prune \%>\% prune_table(all_zero_or_na)
   
tbl_to_prune \%>\% prune_table(all_zero)

tbl_to_prune \%>\% prune_table(content_all_zeros_nas)

tbl_to_prune \%>\% prune_table(prune_empty_level)

tbl_to_prune \%>\% prune_table(prune_zeros_only)

min_prune <- low_obs_pruner(70, "sum")
tbl_to_prune \%>\% prune_table(min_prune)

}
\seealso{
\code{\link[=prune_table]{prune_table()}}, \code{\link[=trim_rows]{trim_rows()}}
}
