% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{table_shell}
\alias{table_shell}
\alias{table_shell_str}
\title{Table shells}
\usage{
table_shell(
  tt,
  widths = NULL,
  col_gap = 3,
  hsep = default_hsep(),
  tf_wrap = FALSE,
  max_width = NULL
)

table_shell_str(
  tt,
  widths = NULL,
  col_gap = 3,
  hsep = default_hsep(),
  tf_wrap = FALSE,
  max_width = NULL
)
}
\arguments{
\item{tt}{\code{TableTree} (or related class). A \code{TableTree} object representing a
populated table.}

\item{widths}{numeric (or  \code{NULL}). (proposed) widths for the columns
of \code{x}. The expected length  of this numeric vector can be
retrieved with  \code{ncol() + 1}  as the  column of row  names must
also be considered.}

\item{col_gap}{numeric(1). Space (in characters) between columns}

\item{hsep}{character(1). Characters to repeat to create
header/body separator line. If \code{NULL}, the object value will be
used. If \code{" "}, an empty separator will be printed. Check \code{\link[formatters:default_hsep]{default_hsep()}}
for more information.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or \code{NULL}. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If \code{NULL}, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}
}
\value{
for \code{table_shell_str} the string representing the table shell, for \code{table_shell},
\code{NULL}, as the function is called for the side effect of printing the shell to the console
}
\description{
A table shell is a rendering of the table which maintains the structure, but does not
display the values, rather displaying the formatting instructions for each cell.
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

lyt <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary), format = "xx.xx")

tbl <- build_table(lyt, iris2)
table_shell(tbl)
}
