% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_channel_mentions.R
\name{tg_channel_mentions}
\alias{tg_channel_mentions}
\title{Getting a list of mentions}
\usage{
tg_channel_mentions(
  channel_id = tg_get_channel_id(),
  start_date = Sys.Date() - 15,
  end_date = Sys.Date()
)
}
\arguments{
\item{channel_id}{Channel ID (@username, t.me/username, t.me/joinchat/AAAAABbbbbcccc ... or channel ID in 'TGStat')}

\item{start_date}{Date mentioned from}

\item{end_date}{Date mentioned to}
}
\value{
tibble with mention data
}
\description{
The method allows you to get a list of mentions of a channel in other channels.
}
\details{
A publication is considered a mention if it contains a link to a channel like username, t.me/username, t.me/username/1234.
In case of mentioning a channel, the \code{mention_type} parameter will contain the value 'channel'. If a specific publication of the channel is mentioned, then the parameter will contain the value 'post'.
}
\examples{
\dontrun{
mentions <- tg_channel_mentions(
    channel_id = 'R4marketing',
    start_date = '2021-10-01',
    end_date = '2021-10-31'
 )
}
}
\references{
See also \href{https://api.tgstat.ru/docs/ru/channels/mentions.html}{TGstat API Documentation of metrod channels/mentions}
}
