% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article.R
\name{acm_article}
\alias{acm_article}
\alias{acs_article}
\alias{aea_article}
\alias{agu_article}
\alias{amq_article}
\alias{ams_article}
\alias{asa_article}
\alias{arxiv_article}
\alias{bioinformatics_article}
\alias{biometrics_article}
\alias{ctex_article}
\alias{ctex}
\alias{elsevier_article}
\alias{frontiers_article}
\alias{glossa_article}
\alias{ims_article}
\alias{informs_article}
\alias{iop_article}
\alias{jasa_article}
\alias{lipics_article}
\alias{lncs_article}
\alias{jedm_article}
\alias{mdpi_article}
\alias{mnras_article}
\alias{peerj_article}
\alias{pihph_article}
\alias{plos_article}
\alias{pnas_article}
\alias{sage_article}
\alias{sim_article}
\alias{springer_article}
\alias{tf_article}
\alias{trb_article}
\alias{wellcomeor_article}
\alias{isba_article}
\title{R Markdown output formats for (journal) articles}
\usage{
acm_article(...)

acs_article(
  ...,
  keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"),
  fig_caption = TRUE
)

aea_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

agu_article(
  ...,
  keep_tex = TRUE,
  citation_package = "natbib",
  highlight = NULL,
  md_extensions = c("-autolink_bare_uris", "-auto_identifiers")
)

amq_article(
  ...,
  latex_engine = "xelatex",
  keep_tex = TRUE,
  fig_caption = TRUE,
  md_extensions = c("-autolink_bare_uris")
)

ams_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

asa_article(..., keep_tex = TRUE, citation_package = "natbib")

arxiv_article(..., keep_tex = TRUE)

bioinformatics_article(..., keep_tex = TRUE, citation_package = "natbib")

biometrics_article(..., keep_tex = TRUE, citation_package = "natbib")

ctex_article(..., template = "default", latex_engine = "xelatex")

ctex(..., template = "default", latex_engine = "xelatex")

elsevier_article(
  ...,
  keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"),
  citation_package = "natbib"
)

frontiers_article(..., keep_tex = TRUE)

glossa_article(..., keep_tex = TRUE, latex_engine = "xelatex")

ims_article(
  journal = c("aoas", "aap", "aop", "aos", "sts"),
  keep_tex = TRUE,
  citation_package = "natbib",
  md_extensions = c("-autolink_bare_uris"),
  pandoc_args = NULL,
  ...
)

informs_article(..., keep_tex = TRUE, citation_package = "natbib")

iop_article(..., keep_tex = TRUE, citation_package = "natbib")

jasa_article(
  ...,
  keep_tex = TRUE,
  latex_engine = "xelatex",
  citation_package = "natbib"
)

lipics_article(
  ...,
  latex_engine = "xelatex",
  keep_tex = TRUE,
  citation_package = "natbib",
  md_extensions = c("-autolink_bare_uris", "-auto_identifiers")
)

lncs_article(..., keep_tex = TRUE, citation_package = c("default", "natbib"))

jedm_article(..., keep_tex = TRUE, citation_package = "natbib")

mdpi_article(
  ...,
  keep_tex = TRUE,
  latex_engine = "pdflatex",
  pandoc_args = NULL,
  citation_package = "natbib"
)

mnras_article(..., keep_tex = TRUE, fig_caption = TRUE)

peerj_article(..., keep_tex = TRUE)

pihph_article(
  ...,
  keep_tex = TRUE,
  latex_engine = "xelatex",
  citation_package = "biblatex"
)

plos_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

pnas_article(..., keep_tex = TRUE)

sage_article(..., highlight = NULL, citation_package = "natbib")

sim_article(..., highlight = NULL, citation_package = "natbib")

springer_article(
  ...,
  keep_tex = TRUE,
  citation_package = "natbib",
  number_sections = TRUE,
  latex_engine = "pdflatex",
  pandoc_args = NULL
)

tf_article(..., keep_tex = TRUE, citation_package = "natbib")

trb_article(..., keep_tex = TRUE, citation_package = "natbib")

wellcomeor_article(
  ...,
  number_sections = FALSE,
  keep_tex = TRUE,
  citation_package = "natbib"
)

isba_article(
  ...,
  keep_tex = TRUE,
  highlight = NULL,
  citation_package = "natbib"
)
}
\arguments{
\item{..., number_sections, keep_tex, latex_engine, citation_package, highlight, fig_caption, md_extensions, template, pandoc_args}{Arguments passed to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}.}

\item{journal}{one of \code{"aoas"}, \code{"aap"}, \code{"aop"}, \code{"aos"}, \code{"sts"} for \code{ims_article}}
}
\value{
An R Markdown output format.
}
\description{
Most article formats are based on \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}, with a
custom Pandoc LaTeX template and different default values for other arguments
(e.g., \code{keep_tex = TRUE}).
}
\section{Details}{
 You can find more details about each output format below.
}

\section{\code{acm_article}}{
 Format for creating an Association for Computing
Machinery (ACM) articles. Adapted from
\url{https://www.acm.org/publications/proceedings-template}.
}

\section{\code{acs_article}}{
 Format for creating an American Chemical Society
(ACS) Journal articles. Adapted from
\verb{https://pubs.acs.org/page/4authors/submission/tex.html}
}

\section{\code{aea_article}}{
 Format for creating submissions to the American
Economic Association (AER, AEJ, JEL, PP).
}

\section{\code{agu_article}}{
 Format for creating a American Geophysical Union
(AGU) article. Adapted from
\url{https://www.agu.org/Publish-with-AGU/Publish/#1}.
}

\section{\code{amq_article}}{
 Ce format a été adapté du format du bulletin de
l'AMQ.
}

\section{\code{ams_article}}{
 Format for creating an American Meteorological
Society (AMS) Journal articles. Adapted from
\url{https://www.ametsoc.org/ams/index.cfm/publications/authors/journal-and-bams-authors/author-resources/latex-author-info/}.
}

\section{\code{asa_article}}{
 This format was adapted from The American
Statistician (TAS) format, but it should be fairly consistent across
American Statistical Association (ASA) journals.
}

\section{\code{arxiv_article}}{
 Adapted from the George Kour's format for
arXiv and bio-arXiv preprints. So far as I'm aware, entirely
unofficial but still a staple.
}

\section{\code{bioinformatics_article}}{
 Format for creating submissions to a Bioinformatics journal. Adapted from
\url{https://academic.oup.com/bioinformatics/pages/submission_online}.
}

\section{\code{biometrics_article}}{
 This format was adapted from the
Biometrics journal.
}

\section{\code{ctex_article}}{
 A wrapper function for
\code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}} and the default value of
\code{latex_engine} is changed to \command{xelatex}, so it works better for
typesetting Chinese documents with the LaTeX package \pkg{ctex}. The
function \code{ctex} is an alias of \code{ctex_article}.
}

\section{\code{elsevier_article}}{
 Format for creating submissions to Elsevier
journals. Adapted from
\url{https://www.elsevier.com/authors/policies-and-guidelines/latex-instructions}.

It requires a minimum version of 2.10 for Pandoc.
}

\section{\code{frontiers_article}}{
 Format for creating Frontiers journal
articles. Adapted from
\url{https://www.frontiersin.org/about/author-guidelines}.
}

\section{\code{glossa_article}}{
 Format for creating submissions to Glossa: a
journal of general linguistics. Author Guidelines are available on
\href{https://www.glossa-journal.org/site/author-guidelines/}{www.glossa-journal.org}.
Template is adapted from \url{https://github.com/guidovw/Glossalatex}.
}

\section{\code{ims_article}}{
 Format for creating submissions to the Institute of Mathematical Statistics
\href{https://imstat.org/}{IMS} journals and publications. Adapted from
\url{https://github.com/vtex-soft/texsupport.ims-aoas}.

The argument \code{journal} accepts the acronym of any of the
\href{https://www.e-publications.org/ims/support/ims-instructions.html}{journals} in IMS:
\itemize{
\item \code{aap}: The Annals of Applied Probability
\item \code{aoas}: The Annals of Applied Statistics
\item \code{aop}: The Annals of Probability
\item \code{aos}: The Annals of Statistics
\item \code{sts}: Statistical Science
}
}

\section{\code{informs_article}}{
 Format for creating submissions to
INFORMS journals. Adapted from \samp{https://pubsonline.informs.org/authorportal/latex-style-files}.

It requires a minimum version of 2.10 for Pandoc.
}

\section{\code{iop_article}}{
 Format for creating submissions to
IOP journals. Adapted from \samp{https://publishingsupport.iopscience.iop.org/questions/latex-template/}.
Please read the guidelines at this link when preparing your article.
}

\section{\code{jasa_article}}{
 Format for creating submissions to the
Journal of the Acoustical Society of America. Adapted from
\url{https://acousticalsociety.org/preparing-latex-manuscripts/}.
}

\section{\code{lipics_article}}{
 Format for creating submissions to
LIPIcs - Leibniz International Proceedings Informatics - articles.
Adapted from the official Instructions for Authors at
\url{https://submission.dagstuhl.de/documentation/authors} and the
template from the archive \code{authors-lipics-v2019.zip} downloaded
with version tag v2019.2. The template is provided under The LaTeX
Project Public License (LPPL), Version 1.3c.
}

\section{\code{lncs_article}}{
 Format for creating submissions to
LNCS - Lecture Notes in Computer Science - articles.
Adapted from the official Instructions for Authors at
\url{https://www.springer.com/gp/computer-science/lncs/conference-proceedings-guidelines}
and the  template from the archive \code{LaTeX2e+Proceedings+Templates+download.zip} downloaded
with version tag 2.21.
}

\section{\code{jedm_article}}{
 Format for creating Journal of Educational
Data Mining (JEDM) articles. Adapted from
\url{https://jedm.educationaldatamining.org/index.php/JEDM/information/authors}.
}

\section{\code{mdpi_article}}{
 Format for creating submissions to
Multidisciplinary Digital Publishing Institute (MDPI) journals. Adapted
from \url{https://www.mdpi.com/authors/latex}.

Possible arguments for the YAML header are:
\itemize{
\item \code{title} title of the manuscript
\item \code{author} list of authors, containing \code{name}, \code{affil}, and \code{orcid} (optional)
\item \code{affiliation} list containing \code{num}, \code{address}, and \code{email} for defining \code{author} affiliations
\item \code{authorcitation} string with last name and first intial of authors as expected to be shown in a reference
\item \code{firstnote} can include \code{firstnote} through \code{eightnote} that correspond to footnote marks in \code{affil}
\item \code{correspondence} contact information of the corresponding author
\item \code{journal} short name (case sensitive) of the journal, see template for options
\item \code{type} usually "article" but see template for options
\item \code{status} usually "submit"
\item \code{simplesummary} optional, may depend on specific journal
\item \code{abstract} abstract, limited to 200 words
\item \code{keywords} 3 to 10 keywords seperated with a semicolon
\item \code{acknowledgement} acknowledgement backmatter (optional)
\item \code{authorcontributions} report authorship contributions (optional)
\item \code{funding} research funding statement
\item \code{institutionalreview} IRB statements (optional)
\item \code{informedconsent} Informed consent statements for human research (optional)
\item \code{dataavailability} Links to datasets or archives (optional)
\item \code{conflictsofinterest} Conflict of interest statement (see journal  instructions)
\item \code{sampleavailability} Sample availability statement (optional)
\item \code{supplementary} Supplementary data statement, see template for example (optional)
\item \code{abbreviations} list of abbreviations containing \code{short} and \code{long}
\item \code{bibliography} BibTeX \code{.bib} file
\item \code{appendix} name of appendix tex file
\item \code{endnote} boolean, if \code{TRUE} will print list of endnotes if included in text (optional)
\item \code{header-includes}: custom additions to the header, before the \verb{\\begin\{document\}} statement
\item \code{include-after}: for including additional LaTeX code before the \verb{\\end\{document\}} statement
}
}

\section{\code{mnras_article}}{
 Format for creating an Monthly Notices of
Royal Astronomical Society (MNRAS) Journal articles. Adapted from
\url{https://ras.ac.uk}.
}

\section{\code{peerj_article}}{
 Format for creating submissions to The PeerJ
Journal. This was adapted from the
\href{https://www.overleaf.com/latex/templates/latex-template-for-peerj-journal-and-pre-print-submissions/ptdwfrqxqzbn}{PeerJ Overleaf Template}.
}

\section{\code{pihph_article}}{
 Format for creating submissions to the Papers
in Historical Phonology
(\url{http://journals.ed.ac.uk/pihph/about/submissions}). Adapted from
\url{https://github.com/pihph/templates}. This format works well with
\code{latex_engine = "xelatex"} and \code{citation_package="biblatex"},
which are the default. It may not work correctly if you change these value.
In that case, please open an issue and, a PR to contribute a change in the
template.
}

\section{\code{plos_article}}{
 Format for creating submissions to PLOS
journals. Adapted from \url{https://journals.plos.org/ploscompbiol/s/latex}.
}

\section{\code{pnas_article}}{
 Format for creating submissions to PNAS
journals.
}

\section{\code{sage_article}}{
 Format for creating submissions to Sage
Journals. Based on the official Sage Journals
\verb{https://uk.sagepub.com/sites/default/files/sage_latex_template_4.zip}{class}.

Possible arguments for the YAML header are:
\itemize{
\item \code{title} title of the manuscript
\item \code{runninghead} short author list for header
\item \code{author} list of authors, containing \code{name} and \code{num}
\item \code{address} list containing \code{num} and \code{org} for defining \code{author} affiliations
\item \code{corrauth} corresponding author name and address
\item \code{email} correspondence email
\item \code{abstract} abstract, limited to 200 words
\item \code{keywords} keywords for the article
\item \code{bibliography} BibTeX \code{.bib} file name
\item \code{classoption} options of the \code{sagej} class
\item \code{header-includes}: custom additions to the header, before the \verb{\\begin\{document\}} statement
\item \code{include-after}: for including additional LaTeX code before the \verb{\\end\\\{document\}} statement
}
}

\section{\code{sim_article}}{
 Format for creating submissions to Statistics in
Medicine. Based on the official Statistics in Medicine
at \verb{https://onlinelibrary.wiley.com/page/journal/10970258/homepage/la_tex_class_file.htm}.

Possible arguments for the YAML header are:
\itemize{
\item \code{title} title of the manuscript
\item \code{author} list of authors, containing \code{name} and \code{num}
\item \code{address} list containing \code{num} and \code{org} for defining \code{author} affiliations
\item \code{presentaddress} not sure what they mean with this
\item \code{corres} author and address for correspondence
\item \code{authormark} short author list for header
\item \code{received}, \code{revised}, \code{accepted} dates of submission, revision, and acceptance of the manuscript
\item \code{abstract} abstract, limited to 250 words
\item \code{keywords} up to 6 keywords
\item \code{bibliography} BibTeX \code{.bib} file
\item \code{classoption} options of the \code{WileyNJD-v2} class
\item \code{longtable} set to \code{true} to include the \code{longtable} package, used by default from \code{pandoc} to convert markdown to LaTeX code
\item \code{header-includes}: custom additions to the header, before the \verb{\\begin\{document\}} statement
\item \code{include-after}: for including additional LaTeX code before the \verb{\\end\{document\}} statement
}
}

\section{\code{springer_article}}{
 This format was adapted from the Springer
Macro package for Springer Journals.
}

\section{\code{tf_article}}{
 Format for creating submissions to a Taylor & Francis journal. Adapted from
\samp{https://www.tandf.co.uk/journals/authors/InteractCADLaTeX.zip}.
}

\section{\code{trb_article}}{
 Format for creating submissions to the Transportation
Research Board Annual Meeting. Adapted from
\samp{https://www.overleaf.com/latex/templates/transportation-research-board-trb-latex-template/jkfndnnkkksw},
which in turn is hosted at \samp{https://github.com/chiehrosswang/TRB_LaTeX_tex}
}

\section{\code{wellcomeor_article}}{
 Format for creating submissions to
Wellcome Open Research. Adapted from <overleaf.com/latex/templates/wellcome-open-research-article-template/hsmhhbpxvvbj>.
}

\section{\code{isba_article}}{
 Format for creating submissions to Bayesian analysis.
Based on the official Bayesian analysis \href{https://www.e-publications.org/isba/support/}{class}.
Template shows how to use this format as a base format for \code{bookdown::pdf_book}, but it can very well be used on its own (with limitations that figure referencing will not work).
Note that the template sets \code{md_extensions} to exclude \code{-autolink_bare_uris} because otherwise author emails produce error

Possible arguments for the YAML header are:
\itemize{
\item \code{title} title of the manuscript. Shorter version of the title can be provided as \code{runtitle}.
\item \code{classoption} should equal \code{ba} or \verb{ba,preprint} for supplementary article.``
\item \code{author} list of authors, containing \code{firstname}, \code{lastname}, \code{email}, \code{url}, \code{affiliationref} (as code) and \code{footnoterefs} (as list of codes)
\item \code{affiliations} list containing \code{ref} (code for defining \code{author} affiliations), institution \code{name} and \code{address} itself
\item \code{footnotes} a list of two-element entries: \code{ref} and \code{text}
\item \code{abstract} abstract, limited to 250 words
\item \code{MSC2020primary}, \code{MSC2020primary} lists of codes from \href{https://mathscinet.ams.org/mathscinet/msc/msc2020.html}{MCS2020 database}
\item \code{keywords} a list of keywords
\item \code{supplements} a list of entries with two elements \code{title} and \code{description}
\item \code{doi} DOI of the article
\item \code{arxiv} Arxiv id
\item \code{acknowledgements} acknowledgement text, limited to 250 words
\item \code{bibliography} BibTeX \code{.bib} file
\item \code{longtable} set to \code{true} to include the \code{longtable} package, used by default from \code{pandoc} to convert markdown to LaTeX code
\item \code{header-includes}: custom additions to the header, before the \verb{\\begin\{document\}} statement
\item \code{include-after}: for including additional LaTeX code before the \verb{\\end\{document\}} statement
}
}

\examples{
\dontrun{
rmarkdown::draft("MyArticle.Rmd", template = "acm", package = "rticles")
rmarkdown::draft("MyArticle.Rmd", template = "asa", package = "rticles")
}
}
