% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtiesShared.R
\name{plotRaw}
\alias{plotRaw}
\title{Plots of observed variable over time by dyad.}
\usage{
plotRaw(
  basedata,
  dyadId,
  obs_name,
  dist_name,
  time_name,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  printPlots = T
)
}
\arguments{
\item{basedata}{A user provided dataframe.}

\item{dyadId}{The name of the column in the dataframe that has the dyad-level identifier.}

\item{obs_name}{The name of the column in the dataframe that has the time-varying observable (e.g., the variable for which dynamics will be assessed).}

\item{dist_name}{The name of the column in the dataframe that has a variable that distinguishes the partners (e.g., sex, mother/daughter, etc) that is numeric and scored 0/1.}

\item{time_name}{The name of the column in the dataframe that indicates sequential temporal observations.}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable to appear on plots (e.g., "Women").}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable to appear on plots (e.g., "Men").}

\item{plot_obs_name}{An optional name for the observed state variable to appear on plots (e.g., "Emotional Experience").}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
A list of plots.
}
\description{
Produces plots of the observed variable for each dyad over time to check for data errors, etc.
}
\examples{
data <- rties_ExampleDataShort
plotRaw(basedata=data, dyad="couple", obs_name="dial", dist_name="female", time_name="time")
}
