% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{get_account_following}
\alias{get_account_following}
\title{Get accounts a user follows}
\usage{
get_account_following(
  id,
  max_id,
  since_id,
  limit = 40L,
  token = NULL,
  parse = TRUE,
  retryonratelimit = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{id}{character, local ID of a user (this is not the username)}

\item{max_id}{character or \code{POSIXct} (date time), Return results older than this id}

\item{since_id}{character or \code{POSIXct} (date time), Return results newer than this id}

\item{limit}{integer, Maximum number of results to return}

\item{token}{user bearer token (read from file by default)}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}

\item{retryonratelimit}{If TRUE, and a rate limit is exhausted, will wait until it refreshes. Most Mastodon rate limits refresh every 5 minutes. If FALSE, and the rate limit is exceeded, the function will terminate early with a warning; you'll still get back all results received up to that point.}

\item{verbose}{logical whether to display messages}
}
\value{
tibble or list of accounts a user follows
}
\description{
Get accounts a user follows
}
\details{
this functions needs a user level auth token. If limit>40, automatic pagination is used. You may get more results than requested.
}
\examples{
\dontrun{
get_account_following("109302436954721982")
}
}
