% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTwoFactor.r
\name{plotTwoFactor}
\alias{plotTwoFactor}
\title{Bar plot of gene expression from an expression table of a two-factorial experiment data}
\usage{
plotTwoFactor(
  data,
  x_col,
  y_col,
  group_col,
  Lower.se_col,
  Upper.se_col,
  letters_col = NULL,
  show.groupingLetters = TRUE
)
}
\arguments{
\item{data}{A data.frame such as the expression result of \code{ANOVA_DDCt(x)} or \code{ANOVA_DCt(x)}, etc. functions.}

\item{x_col}{column number of the x-axis factor.}

\item{y_col}{column number of the y-axis factor.}

\item{group_col}{column number of the grouping factor.}

\item{Lower.se_col}{The column number of the data.frame used for the lower error bar.}

\item{Upper.se_col}{The column number of the data.frame used for the upper error bar.}

\item{letters_col}{The column number of the data.frame used as the result of statistical comparing and grouping.}

\item{show.groupingLetters}{a logical variable. If TRUE, mean grouping letters (the results of statistical comparison) are added to the bars.}
}
\value{
Bar plot of the average fold change for target genes along with the standard error or 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression (\eqn{\Delta C_T} method) of a gene along with the standard error (se), 95\% confidence interval (ci) and significance
}
\details{
The \code{plotTwoFactor} function generates the bar plot of the average fold change for target genes along with the significance, standard error (se) and the 95\% confidence interval (ci) as error bars.
}
\examples{

a <- ANOVA_DCt(data_2factorBlock, block = "Block", numberOfrefGenes = 1)
data <- a$Results

plotTwoFactor(
  data = data,
  x_col = 2,
  y_col = 3,
  group_col = 1,
  Lower.se_col = 8,
  Upper.se_col = 9,
  letters_col = 12,
  show.groupingLetters = TRUE)
              
              
              
# Combining FC results of two different genes:
a <- REPEATED_DDCt(data_repeated_measure_1,
                   numberOfrefGenes = 1,
                   factor = "time", block = NULL, plot = FALSE)

b <- REPEATED_DDCt(data_repeated_measure_2,
                   factor = "time",
                   numberOfrefGenes = 1, block = NULL, plot = FALSE)

a1 <- a$FC_statistics_of_the_main_factor
b1 <- b$FC_statistics_of_the_main_factor
c <- rbind(a1, b1)
c$gene <- factor(c(1,1,1,2,2,2))
c

plotTwoFactor(
  data = c,
  x_col = 1,
  y_col = 2,
  group_col = 13,
  Lower.se_col = 9,
  Upper.se_col = 10,
  letters_col = 5,
  show.groupingLetters = TRUE)


}
\author{
Ghader Mirzaghaderi
}
