% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friends.R
\name{get_friends}
\alias{get_friends}
\title{get_friends}
\usage{
get_friends(user, page = "-1", parse = TRUE, token = NULL)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{page}{Default \code{page = -1} specifies first page of json
results. Other pages specified via cursor values supplied by
Twitter API response object.}

\item{parse}{Logical, indicating whether to return parsed
vector or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves you the time [and frustrations]
associated with disentangling the Twitter API return objects.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}
}
\value{
friends User ids for everyone a user follows.
}
\description{
Requests information from Twitter's REST API
  regarding a user's friend network (i.e., accounts followed
  by a user). To request information on followers of accounts
}
\examples{
\dontrun{
# get ids of users followed by the president of the US
pres <- get_friends(user = "potus")
pres

# get ids of users followed by the Environmental Protection Agency
epa <- get_friends(user = "epa")
epa
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other ids: \code{\link{get_followers}},
  \code{\link{next_cursor}}
}

