% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_list}
\alias{post_list}
\title{Manage Twitter lists}
\usage{
post_list(users = NULL, name = NULL, description = NULL,
  private = FALSE, destroy = FALSE, list_id = NULL, slug = NULL,
  token = NULL)
}
\arguments{
\item{users}{Character vectors of users to be added to list.}

\item{name}{Name of new list to create.}

\item{description}{Optional, description of list (single character string).}

\item{private}{Logical indicating whether created list should be private.
Defaults to false, meaning the list would be public. Not applicable if list
already exists.}

\item{destroy}{Logical indicating whether to delete a list. Either `list_id` or
`slug` must be provided if `destroy = TRUE`.}

\item{list_id}{Optional, numeric ID of list.}

\item{slug}{Optional, list slug.}

\item{token}{OAuth token associated with user who owns [or will own] the list
of interest. Token must have write permissions!}
}
\value{
Response object from HTTP request.
}
\description{
Create, add users, and destroy Twitter lists
}
\examples{
\dontrun{

## CNN twitter accounts
users <- c("cnn", "cnnbrk", "cnni", "cnnpolitics", "cnnmoney",
  "cnnnewsroom", "cnnspecreport", "CNNNewsource",
  "CNNNSdigital", "CNNTonight")

## create CNN-accounts list with 9 total users
(cnn_lst <- post_list(users,
  "cnn-accounts", description = "Official CNN accounts"))

## view list in browser
browseURL(sprintf("https://twitter.com/\%s/lists/cnn-accounts",
  rtweet:::home_user()))

## search for more CNN users
cnn_users <- search_users("CNN", n = 200)

## filter and select more users to add to list
more_users <- cnn_users \%>\%
  subset(verified & !tolower(screen_name) \%in\% tolower(users)) \%>\%
  .$screen_name \%>\%
  grep("cnn", ., ignore.case = TRUE, value = TRUE)

## add more users to list- note: can only add up to 100 at a time
post_list(users = more_users, slug = "cnn-accounts")

## view updated list in browser (should be around 100 users)
browseURL(sprintf("https://twitter.com/\%s/lists/cnn-accounts",
  rtweet:::home_user()))

## select users on list without "cnn" in their name field
drop_users <- cnn_users \%>\%
  subset(screen_name \%in\% more_users & !grepl("cnn", name, ignore.case = TRUE)) \%>\%
  .$screen_name

## drop these users from the cnn list
post_list(users = drop_users, slug = "cnn-accounts",
  destroy = TRUE)

## view updated list in browser (should be around 100 users)
browseURL(sprintf("https://twitter.com/\%s/lists/cnn-accounts",
  rtweet:::home_user()))

## delete list entirely
post_list(slug = "cnn-accounts", destroy = TRUE)

}
}
