% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-user.R
\name{post_follow}
\alias{post_follow}
\alias{follow_user}
\alias{post_unfollow_user}
\alias{unfollow_user}
\alias{post_mute}
\alias{mute_user}
\title{Follows target Twitter user.}
\usage{
post_follow(
  user,
  destroy = FALSE,
  mute = FALSE,
  notify = FALSE,
  retweets = TRUE,
  token = NULL
)

post_unfollow_user(user, token = NULL)

post_mute(user, token = NULL)
}
\arguments{
\item{user}{Character vector of screen names or user ids.
See \code{\link[=as_screenname]{as_screenname()}} for more details.}

\item{destroy}{Logical indicating whether to post (add) or
remove (delete) target tweet as favorite.}

\item{mute}{Logical indicating whether to mute the intended
friend (you must already be following this account prior
to muting them)}

\item{notify}{Logical indicating whether to enable notifications
for target user. Defaults to false.}

\item{retweets}{Logical indicating whether to enable retweets
for target user. Defaults to true.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}
}
\description{
Follows target Twitter user.
}
\examples{
if (auth_has_default()) {
    post_follow("_R_Foundation")
    post_follow("rtweet_test", mute = TRUE) # Mute
}
}
\references{
Update: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/follow-search-get-users/api-reference/post-friendships-update}
Create: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/follow-search-get-users/api-reference/post-friendships-create}
Destroy: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/follow-search-get-users/api-reference/post-friendships-destroy}
Mute: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/mute-block-report-users/api-reference/post-mutes-users-create}
}
\seealso{
Other post: 
\code{\link{post_favorite}()},
\code{\link{post_friendship}()},
\code{\link{post_tweet}()}
}
\concept{post}
