% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_loglik}
\alias{DAGM_loglik}
\title{DAGM log-likelihood (with skewness)}
\usage{
DAGM_loglik(param, daily_ret, mv_m, K, distribution)
}
\arguments{
\item{param}{Vector of starting values. It must be a eight- or nine- dimensional vector. See the examples below.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{distribution}{The conditional dentisity to use for the innovations. At the moment, valid choices are "norm" and "std", for the Normal
and Student-t distributions.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the DAGM, with an asymmetric term linked to past negative returns,
according to two errors' conditional distributions: Normal and Student-t.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
# conditional density of the innovations: normal
# start_val<-c(0.01,0.80,0.05,0,0,1.1,0,1.1)
# r_t<-sp500['2005/2010']
# mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
# sum(DAGM_loglik(start_val,r_t,mv_m,K=12,distribution="norm"))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
