% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{MEM_MIDAS_loglik}
\alias{MEM_MIDAS_loglik}
\title{MEM-MIDAS log-likelihood (with skewness parameter)}
\usage{
MEM_MIDAS_loglik(param, x, daily_ret, mv_m, K)
}
\arguments{
\item{param}{Vector of starting values. It must be a six--dimensional vector. See the example below.}

\item{x}{Dependent variable, usually the realized volatility. It must be positive and "xts" object.}

\item{daily_ret}{Daily returns, which must be an "xts" object, and with the same length of x.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the MEM-MIDAS, with an asymmetric term linked to past negative returns.
For details, see \insertCite{amendola2020doubly;textual}{rumidas} and \insertCite{engle_gallo_2006;textual}{rumidas}.
}
\examples{
# start_val<-c(alpha=0.10,beta=0.8,gamma=0.1,m=0,theta=-0.16,w2=5)
# r_t<-sp500['/2010']
# real<-(rv5['/2010'])^0.5		# realized volatility
# mv_m<-mv_into_mat(real,diff(indpro),K=12,"monthly")
# sum(MEM_MIDAS_loglik(start_val,real,r_t,mv_m,K=12))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
