% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mean_run}
\alias{mean_run}
\title{Running mean}
\usage{
mean_run(x, k = 0L, na_rm = TRUE, na_pad = FALSE)
}
\arguments{
\item{x}{vector of any type on which running mean is calculated}

\item{k}{running window size. Not yet implemented.}

\item{na_rm}{logical (default \code{na_rm=TRUE}) - if \code{TRUE} mean is calulating excluding \code{NA}.}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}
}
\value{
numeric vector of length equals length of \code{x} containing running mean in \code{k}-long window.
}
\description{
Running mean
}
\examples{
set.seed(11)
x1 <- rnorm(15)
x2 <- sample(c(rep(NA,5),rnorm(15)), 15, replace=TRUE)
k <- sample(1:15, 15, replace=TRUE)
mean_run(x1)
mean_run(x2, na_rm = TRUE)
mean_run(x2, na_rm = FALSE )
mean_run(x2, na_rm = TRUE, k=4)
}
