% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{runner}
\alias{runner}
\title{Apply running function}
\usage{
runner(
  x,
  f,
  k = integer(0),
  lag = integer(1),
  idx = integer(0),
  at = integer(0),
  na_pad = FALSE,
  ...,
  type = "auto"
)
}
\arguments{
\item{x}{Vector of any type}

\item{f}{\code{function} to be applied on windows created from \code{x}}

\item{k}{(\code{integer}) vector or single value denoting size of the running
window. If \code{k} is a single value then window size is constant for all
elements, otherwise if \code{length(k) == length(x)} different window size
for each element.}

\item{lag}{(\code{integer}) vector or single value denoting window lag.
If \code{lag} is a single value then window lag is constant for all elements,
otherwise if \code{length(lag) == length(x)} different window size for each
element. Negative value shifts window forward.}

\item{idx}{(\code{date or integer}) an optional integer vector containing
index of observation. If specified
then \code{k} and \code{lag} are depending on \code{idx}. Length of
\code{idx} should be equal of length \code{x}}

\item{at}{(\code{date or integer}) vector of any size and any value
defining output data points. Values of the vector defines the indexes which
data is computed at. If \code{idx} is missing then uses indices from \code{1}
 to \code{length(x)}, otherwise depends on indexes passed with \code{idx}.
 If \code{at} is defined then \code{k} and \code{lag} should be of length equal
 one or length of the \code{at}.}

\item{na_pad}{\code{logical} single value (default \code{na_pad=FALSE}) - if
\code{TRUE} calculation on incomplete window will return \code{NA}.
Incomplete window is when some parts of the window are out of range}

\item{...}{other arguments passed to the function \code{f}.}

\item{type}{output type \code{("logical", "numeric", "integer", "character")}.
\code{runner} by default returns numeric values, but if function is expected
to return other type, user should specify this in \code{type} argument.}
}
\value{
vector with aggregated values for each window. Length of output is the
same as \code{length(x)} or \code{length(at)} if specified. Type of the output
is taken from \code{type} argument.
}
\description{
Applies custom function on running windows.
}
\examples{

# mean on k = 3 elements windows
runner(1:10, f = mean, k = 3)

# mean on k = 3 elements windows with different specification
runner(1:10, k = 3, f = function(x) mean(x, na.rm = TRUE))

# number of unique values in each window (varying window size)
runner(letters[1:10],
       k = c(1, 2, 2, 4, 5, 5, 5, 5, 5, 5),
       f = function(x) length(unique(x)))

# concatenate window values
runner(letters[1:10],
       k = c(1, 2, 2, 4, 5, 5, 5, 5, 5, 5),
       f = function(x) paste(x, collapse = "-"),
       type = "character")

# concatenate only on selected windows index
runner(letters[1:10],
       f = function(x) paste(x, collapse = "-"),
       at = c(1, 5, 8),
       type = "character")

}
