\name{sims}
\title{Retrieve the Simulations of Random Vectors}
\alias{sims}
\alias{sims.rv}
\alias{sims.default}
\usage{
 sims(x, n.sims=NULL, dimensions=FALSE, sim.matrix=FALSE, mc.array=FALSE)
 \method{sims}{default}(x, ...)
 \method{sims}{rv}(x, n.sims=NULL, dimensions=FALSE, sim.matrix=FALSE, mc.array=FALSE)
}
\description{
  Returns the simulation matrix for the random variable object \code{x}.
}
\arguments{
  \item{x}{a random variable  object} 
  \item{n.sims}{(optional) number of simulations}
  \item{dimensions}{logical, try to preserve the dimensions of \code{x}}
  \item{sim.matrix}{logical, (if dimensions is TRUE) indicate if want to return the plain simulation matrix as attribute ``sim.matrix"}
  \item{mc.array}{logical, indicate if want to return the original 3-way mcmc matrix, if possible}
  \item{\dots}{omitted arguments}
}
\details{
  \code{sims} returns the matrix of simulations for a given random variable object \code{x}. 
}
\references{Kerman, Jouni and Gelman, Andrew. Manipulating and Summarizing Posterior Simulations Using Random Variable Objects. Technical report, Columbia University, New York.
}
\author{
 Jouni Kerman
 \email{kerman@stat.columbia.edu}
 \url{http://www.stat.columbia.edu/~kerman}
}
\examples{
  x <- rvnorm(24)               # Suppose that L is the number of simulations per scalar
  dim(x) <- c(2,3,4)
  dim(sims(x))                  # Lx24
  dim(sims(x, dimensions=TRUE)) # Lx2x3x4
  dim(attr(sims(x, dimensions=TRUE, sim.matrix=TRUE), "sim.matrix")) # Lx24
  \dontrun{dim(sims(x, mc.array=TRUE))} # Error: x was not generated by a mcmc process
}
\keyword{classes}

