% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvbeta.R
\name{rvbeta}
\alias{rvbeta}
\alias{rvnbeta}
\title{Generate Random Vectors from a Beta Sampling Model}
\usage{
rvbeta(n = 1, shape1, shape2)
}
\arguments{
\item{n}{integer, number of random variables to generate}

\item{shape1}{positive number or rv, 1st shape parameter}

\item{shape2}{positive number or rv, 2nd shape parameter}
}
\description{
\code{rvbeta} generates a random vector from the beta sampling model;
}
\details{
\code{rvnbeta(n, a, b)} ("neutral" Beta distribution) is equivalent to
\code{rvbeta(n, 1/3+a, 1/3+b)}.
}
\examples{

   n <- 12         # sample size
   y <- (0:(n-1))  # observations
   a <- b <- 1/3   # the neutral beta prior
   rvbeta(1, shape1=a+y, shape2=b+n-y)
   rvnbeta(1, shape1=y, shape2=n-y)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
