% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_pptx.R
\name{dml_pptx}
\alias{dml_pptx}
\title{DrawingML graphic device for Microsoft PowerPoint}
\usage{
dml_pptx(file = "Rplots.dml", width = 6, height = 6, offx = 1,
  offy = 1, bg = "white", fonts = list(), pointsize = 12,
  editable = TRUE, id = 1L, last_rel_id = 1L,
  raster_prefix = "raster_", standalone = TRUE)
}
\arguments{
\item{file}{the file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{offx, offy}{top and left origin of the plot}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by \code{\link[gdtools]{match_family}()}.}

\item{pointsize}{default point size.}

\item{editable}{should vector graphics elements (points, text, etc.) be editable.}

\item{id}{specifies a unique identifier (integer) within the slide
that will contain the DrawingML instructions.}

\item{last_rel_id}{specifies the last unique identifier (integer)
within relationship file that will be used to reference embedded
raster images if any.}

\item{raster_prefix}{string value used as prefix for png
files produced when raster objects are printed on the
graphical device.}

\item{standalone}{produce a standalone drawingml file? If \code{FALSE}, omits
xml header and namespaces.}
}
\description{
Graphics devices for Microsoft PowerPoint DrawingML format.
}
\examples{
\donttest{
dml_pptx( file = tempfile() )
plot(1:11,(-5:5)^2, type='b', main="Simple Example")
dev.off()
}
}
\seealso{
\code{\link{Devices}}
}
\keyword{device}
