% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pseudo_obs}
\alias{pseudo_obs}
\title{Pseudo-Observations}
\usage{
pseudo_obs(x, ties_method = "average", lower_tail = TRUE)
}
\arguments{
\item{x}{vector or matrix random variates to be converted (column wise) to
pseudo-observations.}

\item{ties_method}{similar to \code{ties.method} of \code{\link[=rank]{rank()}} (only \code{"average"},
\code{"first"} and \code{"random"} currently available).}

\item{lower_tail}{\code{logical} which, if `FALSE``, returns the
pseudo-observations when applying the empirical marginal survival
functions.}
}
\value{
a vector of matrix of the same dimension as the input containing the
pseudo-observations.
}
\description{
Compute the pseudo-observations for the given data matrix.
}
\details{
Given \code{n} realizations \eqn{x_i=(x_{i1}, \ldots,x_{id})},
\eqn{i \in \left\lbrace 1, \ldots,n \right\rbrace }
of a random vector \code{X}, the pseudo-observations are defined via
\eqn{u_{ij}=r_{ij}/(n+1)} for
\eqn{i \in \left\lbrace 1, \ldots,n \right\rbrace}
and
\eqn{j \in \left\lbrace 1, \ldots,d \right\rbrace }, where
\eqn{r_{ij}} denotes the rank of \eqn{x_{ij}} among all \eqn{x_{kj}},
\eqn{k \in \left\lbrace 1, \ldots,n \right\rbrace }.

The pseudo-observations can thus also be computed by component-wise applying
the empirical distribution functions to the data and scaling the result by
\eqn{n/(n+1)}. This asymptotically negligible scaling factor is used to force
the variates to fall inside the open unit hypercube, for example, to avoid
problems with density evaluation at the boundaries.

When \code{lower_tail = FALSE}, then \code{pseudo_obs()} simply returns
\code{1 - pseudo_obs()}.
}
\examples{
# pseudo-observations for a vector
pseudo_obs(rnorm(10))

# pseudo-observations for a matrix
pseudo_obs(cbind(rnorm(10), rnorm(10)))
}
