% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape.R
\name{melb_walk}
\alias{melb_walk}
\title{API using compedapi to Melbourne pedestrian data}
\usage{
melb_walk(from = to - 6L, to = Sys.Date() - 1L, na.rm = FALSE, session = NULL)
}
\arguments{
\item{from}{Starting date.}

\item{to}{Ending date.}

\item{na.rm}{Logical. \code{FALSE} is the default suggesting to include \code{NA} in
the dataset. \code{TRUE} removes the \code{NA}s.}

\item{session}{\code{NULL} or "shiny". For internal use only.}
}
\value{
A tibble including these variables as follows:
\itemize{
\item Sensor: Sensor name (43 sensors up to date)
\item Date_Time: Date time when the pedestrian counts are recorded
\item Date: Date associated with Date_Time
\item Time: Time of day
\item Count: Hourly counts
}
}
\description{
Provides API using compedapi to Melbourne pedestrian data in a tidy data form.
}
\details{
It provides API using compedapi, where counts are uploaded on a
daily basis. The up-to-date data would be
till the previous day. The data is sourced from \href{https://data.melbourne.vic.gov.au/Transport-Movement/Pedestrian-volume-updated-monthly-/b2ak-trbp}{Melbourne Open Data Portal}. Please
refer to Melbourne Open Data Portal for more details about the dataset and
its policy.
}
\examples{
\dontrun{
# Retrieve last week data
melb_walk()

# Retrieve data of a speficied period
start_date <- as.Date("2017-07-01")
end_date <- start_date + 6L
melb_walk(from = start_date, to = end_date)
}
}
\seealso{
\link{melb_walk_fast}
}
