% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phi_curves.R
\name{plot_phi_curves}
\alias{plot_phi_curves}
\title{Plot true and estimated curves for P(Y=1|T=t)}
\usage{
plot_phi_curves(
  theta_true,
  theta.hat_joint,
  theta.hat_midpoint,
  theta.hat_uniform
)
}
\arguments{
\item{theta_true}{the coefficients of the data-generating model P(Y=1|T=t)}

\item{theta.hat_joint}{the estimated coefficients from the joint model}

\item{theta.hat_midpoint}{the estimated coefficients from midpoint imputation}

\item{theta.hat_uniform}{the estimated coefficients from uniform imputation}
}
\value{
a ggplot
}
\description{
Plot true and estimated curves for P(Y=1|T=t)
}
\examples{
\dontrun{

theta_true = c(0.986, -3.88)
hazard_alpha = 1
hazard_beta = 0.5
sim_data = simulate_interval_censoring(
  "theta" = theta_true,
  "study_cohort_size" = 4500,
  "preconversion_interval_length" = 365,
  "hazard_alpha" = hazard_alpha,
  "hazard_beta" = hazard_beta)

# extract the participant-level and observation-level simulated data:
sim_participant_data = sim_data$pt_data
sim_obs_data = sim_data$obs_data
rm(sim_data)

# joint model:
EM_algorithm_outputs = fit_joint_model(
  obs_level_data = sim_obs_data,
  participant_level_data = sim_participant_data,
  bin_width = 7,
  verbose = FALSE)

# midpoint imputation:
theta_est_midpoint = fit_midpoint_model(
  obs_level_data = sim_obs_data,
  participant_level_data = sim_participant_data
)

# uniform imputation:
theta_est_uniform = fit_uniform_model(
  obs_level_data = sim_obs_data,
  participant_level_data = sim_participant_data
)
plot2 = plot_phi_curves(
  theta_true = theta_true,
  theta.hat_uniform = theta_est_uniform,
  theta.hat_midpoint = theta_est_midpoint,
  theta.hat_joint = EM_algorithm_outputs$Theta)

print(plot2)
}

}
