% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{fqpskdemod}
\alias{fqpskdemod}
\title{QPSK Demodulator}
\usage{
fqpskdemod(r)
}
\arguments{
\item{r}{- received signal plus noise.}
}
\value{
retruns a vector of 1's and 0's, 2 bits per input element (i.e., QPSK symbol)
}
\description{
Receives a vector of complex values, r, corresponding to a
QPSK modulated signal transmitted through a communications channel
(e.g., signal plus noise). The received signal, r, is mapped to its in-phase (real part) and
quadrature parts (imaginary part) and demodulated, such that two binary bits are output
for each value of r. If the in-phase part is > 0 then the corresponding output bit value is 1,
otherwise 0. Similarly, if the quadrature part (imaginary) > 0 then the corresponding bit value
is 1, otherwise 0.
}
\examples{
M=4
Es=1
Nsymbols=10
Nbits=log2(M)*Nsymbols
Eb=Es/log2(M)
bits <- sample(0:1,Nbits, replace=TRUE)
s <- fqpskmod(bits)
EbNodB=8
No = Eb/(10^(EbNodB/10))
n <- fNo(Nsymbols,No,type="complex")
r <- s+n
bitsr <- fqpskdemod(r)
biterrs<-bits[bitsr!=bits]
Pberr=length(biterrs)/length(bits)
}
\seealso{
Other modulation.demodulation.communications: \code{\link{f16qamdemod}};
  \code{\link{f16qammod}}; \code{\link{f64qamdemod}};
  \code{\link{f64qammod}}; \code{\link{f8pskdemod}};
  \code{\link{f8pskmod}}; \code{\link{fNo}};
  \code{\link{fbpskdemod}}; \code{\link{fbpskmod}};
  \code{\link{fqpskmod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}
}

