% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwisp.r
\name{wispcalc}
\alias{wispcalc}
\title{Integrated Simple Weighted Sum Product Method - WISP}
\usage{
wispcalc(data, alternatives, optimizations, weights)
}
\arguments{
\item{data}{A numeric data matrix, columns are the criteria, rows are the alternatives}

\item{alternatives}{A character vector with the identification of alternatives}

\item{optimizations}{A character vector with definition of minimization or maximization for each criterion, expected 'min' or 'max' only}

\item{weights}{A numeric vector with the criteria weights, the sum of all must be 1}
}
\value{
list with 3 matrix, ui = ranking and the global ui, normalizedData = normalized data, utilities = utility values
}
\description{
Implementation of An Integrated Simple Weighted Sum Product Method - WISP
More information about the method at https://doi.org/10.1109/TEM.2021.3075783
More information about the implementation at https://github.com/dioubernardo/rwisp/blob/main/README.md
}
\examples{
alternatives <- c("A1", "A2", "A3", "A4", "A5")
optimizations <- c("max", "min", "max", "max")
weights <- c(0.3, 0.25, 0.25, 0.2)
data <- matrix(c(
  c(80000, 50000, 70000, 65000, 75000), # criterion 1 values
  c(400, 150, 250, 300, 100), # criterion 2 values
  c(6, 6, 9, 4, 6), # criterion 3 values
  c(9, 7, 7, 8, 6) # criterion 4 values
), nrow=5, ncol=4)
result <- wispcalc(data, alternatives, optimizations, weights)
}
