% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_badges.R
\name{use_badges}
\alias{use_badges}
\title{Use badges}
\usage{
use_badges(
  add_hex = TRUE,
  add_actions = "rworkflows",
  add_doi = NULL,
  add_github_version = TRUE,
  add_commit = TRUE,
  add_code_size = TRUE,
  add_codecov = TRUE,
  add_license = TRUE,
  add_authors = TRUE,
  add_bioc_release = FALSE,
  add_bioc_download_month = FALSE,
  add_bioc_download_total = FALSE,
  add_bioc_download_rank = FALSE,
  add_cran_release = FALSE,
  add_cran_checks = FALSE,
  add_cran_download_month = FALSE,
  add_cran_download_total = FALSE,
  branch = "master",
  as_list = FALSE,
  sep = "\\n",
  hex_height = 600,
  colors = list(github = "black", bioc = "green", cran = "blue", default = "blue"),
  verbose = TRUE
)
}
\arguments{
\item{add_hex}{Add a hex sticker. 
If \code{add_hex=TRUE}, will assume the sticker is located at the following
 relative path: "inst/hex/hex.png". 
 If \code{add_hex} is a character string, this will instead
be used as the relative hex path (e.g. \code{"/images/mysticker.png"}).}

\item{add_actions}{The name of one or more GitHub Actions to show the 
status for with \link[badger]{badge_github_actions}
 (e.g. c("rworkflows","rworkflows_static")).}

\item{add_doi}{Add the DOI of a given package or publication 
associated with the package. Must be provided as a character string.}

\item{add_github_version}{Add package version with 
\link[badger]{badge_github_version}.}

\item{add_commit}{Add the last GitHub repo commit date with
\link[badger]{badge_last_commit}.}

\item{add_code_size}{Add code size with
\link[badger]{badge_code_size}.}

\item{add_codecov}{Add CodeCov status with
\link[badger]{badge_codecov}.}

\item{add_license}{Add license info with
\link[badger]{badge_license}.}

\item{add_authors}{Add author names inferred from 
the \code{DESCRIPTION} file.}

\item{add_bioc_release}{Add Bioc release version with 
\link[badger]{badge_bioc_release}.}

\item{add_bioc_download_month}{Add the number of Bioc downloads last month 
\link[badger]{badge_bioc_download}.}

\item{add_bioc_download_total}{Add the number of Bioc downloads total
\link[badger]{badge_bioc_download}.}

\item{add_bioc_download_rank}{Add the download rank of the package on Bioc
\link[badger]{badge_bioc_download_rank}.}

\item{add_cran_release}{Add Bioc release version with 
\link[badger]{badge_cran_release}.}

\item{add_cran_checks}{Add whether package is passing all checks on CRAN 
with \link[badger]{badge_cran_checks}.}

\item{add_cran_download_month}{Add the number of CRAN downloads last month 
\link[badger]{badge_cran_download}.}

\item{add_cran_download_total}{Add the number of CRAN downloads total
\link[badger]{badge_cran_download}.}

\item{branch}{Name of the GitHub repository branch to use.}

\item{as_list}{Return the header as a named list (\code{TRUE}), 
or a collapsed text string (default: \code{FALSE}).}

\item{sep}{Character to separate each item in the list with 
using \link[base]{paste}.}

\item{hex_height}{Height of the hex sticker in pixels
(when \code{add_hex=TRUE}).}

\item{colors}{Colors to assign to each group of badges (when possible).}

\item{verbose}{Print messages.}
}
\value{
A named list of selected badges in markdown format.
}
\description{
Create one or more badges showing the status of your R package.
Uses the package 
\href{https://github.com/GuangchuangYu/badger}{\pkg{badger}}.
}
\examples{
## Causes issues bc examples can't find the  the DESCRIPTION file.
 \dontrun{
 rworkflows::use_badges() 
 }
}
