% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast10day}
\alias{forecast10day}
\title{Forecast for the next 10 days.}
\usage{
forecast10day(location, use_metric = FALSE, key = get_api_key(),
  raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df with date (in posix format), high and low temp,
        conditions, precipitation, rain, snow,
        max and avg wind speed, max/min and avg humidity
}
\description{
Forecast for the next 10 days.
}
\examples{
\dontrun{
forecast10day(set_location(territory = "Hawaii", city = "Honolulu"))
forecast10day(set_location(airport_code = "SEA"))
forecast10day(set_location(zip_code = "90210"))
forecast10day(set_location(territory = "IR", city = "Tehran"))
}
}

