% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikGamma}
\alias{llikGamma}
\title{log likelihood and derivatives for Gamma distribution}
\usage{
llikGamma(x, shape, rate, full = FALSE)
}
\arguments{
\item{x}{variable that is distributed by gamma distribution}

\item{shape}{this is the distribution's shape parameter. Must be positive.}

\item{rate}{this is the distribution's rate parameters.  Must be positive.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dProb}
that has the derivatives with respect to the \code{prob} parameters at
the observation time-point
}
\description{
log likelihood and derivatives for Gamma distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikGamma()} but you have to
use the x and rate arguments.  You can also get the derivative of \code{shape} or \code{rate} with
\code{llikGammaDshape()} and \code{llikGammaDrate()}.
}
\examples{

llikGamma(1, 1, 10)

et  <- et(seq(0.001, 1, length.out=10))
et$shape <- 1
et$rate <- 10
 
model <- rxode2({
  fx <- llikGamma(time, shape, rate)
  dShape<- llikGammaDshape(time, shape, rate)
  dRate <- llikGammaDrate(time, shape, rate)
})


rxSolve(model, et)

}
\author{
Matthew L. Fidler
}
