% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_article_images.R
\name{get_article_images}
\alias{get_article_images}
\title{Get article images}
\usage{
get_article_images(url, timeout = 0, download = NULL)
}
\arguments{
\item{url}{character. A single character string or character vector.}

\item{timeout}{integer. Seconds to wait between queries.}

\item{download}{character. Path to download folder. If path is set to \code{NULL} images are not downloaded.}
}
\value{
A data frame including meta information for each image.
}
\description{
Get the article images for a single url or a vector of urls.
}
\details{
\code{get_article_images} is the function, which fetches and parses meta information for each image of an article and downloads the images. This function may break in the future due to layout changes on the ZEIT ONLINE website.
}
\examples{
\dontrun{
url <- paste0("https://www.zeit.de/kultur/film/2018-04/",
"tatort-frankfurt-unter-kriegern-obduktionsbericht")
get_article_images(url = url, timeout = 0)
}

}
\author{
Jan Dix <\email{jan.dix@uni-konstanz.de}>
}
