# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Construct a S2Cap using axis and height
#'
#' Constructs a S2Cap from axis and height
#'
#' @param axis A numeric vector with three entries represtenting the direction axis.
#' @param height Single numeric representing the height of the cap.
#' @export S2CapFromAxisHeight
S2CapFromAxisHeight <- function(axis, height) {
    .Call(`_s2_S2CapFromAxisHeight`, axis, height)
}

S2Cap_contains_point <- function(points, cap) {
    .Call(`_s2_S2Cap_contains_point`, points, cap)
}

#' Area of s2cap
#'
#' Area of a cap
#'
#' @param cap Named list containing axis and height of cap.
#' @export S2Cap_area
S2Cap_area <- function(cap) {
    .Call(`_s2_S2Cap_area`, cap)
}

#' Bounding latitude and longitude rectangle for spherical cap
#'
#' Bounding latitude and longitude rectangle for spherical cap
#' 
#' @param x cap
#' @export
S2Cap_GetRectBound <- function(x) {
    .Call(`_s2_S2Cap_GetRectBound`, x)
}

#' Make a Vector of S2CellIds From Points on the Sphere
#'
#' Create a vector of S2CellIds corresponding to the cells at the given level 
#' containing the given points. The default level (30) corresponds to leaf
#' cells (finest level).
#'
#' @param x Three-column matrix reprensenting the points.
#' @param level Integer between 0 and 30 (incl).
#' @return An object of class `S2CellId`.
#' @export S2CellIdFromPoint
S2CellIdFromPoint <- function(x, level = 30L) {
    .Call(`_s2_S2CellIdFromPoint`, x, level)
}

#' Convert S2CellId to a S2Point
#'
#' Convert S2CellId to a S2Point
#'
#' @param x Object of class S2CellId.
#' @return Three-column matrix reprensenting the points..
#' @export S2CellId_ToPoint
S2CellId_ToPoint <- function(x) {
    .Call(`_s2_S2CellId_ToPoint`, x)
}

#' Make a vector of S2CellId strings
#'
#' Make a vector of S2CellId strings
#'
#' @param x A charecter vector with S2CellIds (in token form).
#' @return A character vector with S2CellId strings.
#' @export S2CellId_ToString
S2CellId_ToString <- function(x) {
    .Call(`_s2_S2CellId_ToString`, x)
}

S2Cell_vertices_from_token <- function(tokens) {
    .Call(`_s2_S2Cell_vertices_from_token`, tokens)
}

S2Cell_vertices_from_point <- function(mat, level) {
    .Call(`_s2_S2Cell_vertices_from_point`, mat, level)
}

S2Cell_grid_centers <- function(level) {
    .Call(`_s2_S2Cell_grid_centers`, level)
}

S2Covering_internal <- function(x, type, max_cells, min_level, max_level, interior) {
    .Call(`_s2_S2Covering_internal`, x, type, max_cells, min_level, max_level, interior)
}

#' Create a rectangle of latitude and longitude on the sphere
#'
#' Create a rectangle of latitude and longitude on the sphere
#' 
#' @param lo Latitude and longitude (in that order) in degrees of lower left corner.
#' @param hi Latitude and longitude (in that order) in degrees of upper right corner.
#' @export S2LatLngRect
S2LatLngRect <- function(lo, hi) {
    .Call(`_s2_S2LatLngRect`, lo, hi)
}

#' Area of s2latlngrect
#'
#' Area of a S2LatLngRect.
#'
#' @param x Named list containing axis and height of cap.
#' @export S2LatLngRect_area
S2LatLngRect_area <- function(x) {
    .Call(`_s2_S2LatLngRect_area`, x)
}

#' Interpolation of points on unit sphere
#' 
#' Given a sequence of points on the unit sphere add interpolating points so
#' consecutive points are within distance `eps` of each other.
#' @param x Matrix with three columns representing the points.
#' @param eps Strictly positive real number. Values greater than or equal to pi
#' correspond to no interpolation.
#' @export S2Point_interpolate
S2Point_interpolate <- function(x, eps) {
    .Call(`_s2_S2Point_interpolate`, x, eps)
}

S2PolygonBuild <- function(x, validate = TRUE, xor_edges = TRUE, vertex_merge_radius = 0, edge_splice_fraction = 0.866, undirected_edges = FALSE) {
    .Call(`_s2_S2PolygonBuild`, x, validate, xor_edges, vertex_merge_radius, edge_splice_fraction, undirected_edges)
}

#' Union and intersection of two s2polygons
#'
#' Given two lists of three column matrices representing S2Polygons calculate
#' the union or intersection. Assumes the polygons have already been validated
#' and put into the correct format by [`S2Polygon`]. Note the input is only the
#' loops/rings of two polygons not the entire objects with areas and hole
#' indicators.
#' 
#' @param x List of loops represented by three-column matrices.
#' @param y List of loops represented by three-column matrices.
#' @aliases S2Polygon_intersection
#' @export S2Polygon_union
S2Polygon_union <- function(x, y) {
    .Call(`_s2_S2Polygon_union`, x, y)
}

#' @export S2Polygon_intersection
S2Polygon_intersection <- function(x, y) {
    .Call(`_s2_S2Polygon_intersection`, x, y)
}

#' intersection of sets of s2polygons
#'
#' this function generalizes S2Polygon_intersection, by allowing two lists of
#' polygons, each list element equal to a polygon of that function.
#' 
#' @param x List of list of loops represented by three-column matrices.
#' @param y List of list of loops represented by three-column matrices.
#' @aliases S2Polygons_intersection
#' @export S2Polygons_intersection
S2Polygons_intersection <- function(x, y) {
    .Call(`_s2_S2Polygons_intersection`, x, y)
}

#' for two sets of s2polygons, which ones intersect?
#'
#' this function is equivalent to \link[sf]{st_intersects}, in that it
#' returns a sparse matrix with indexes for pairs of intersecting polygons
#' 
#' @param x List of list of loops represented by three-column matrices.
#' @param y List of list of loops represented by three-column matrices.
#' @aliases S2Polygons_intersect
#' @export S2Polygons_intersect
S2Polygons_intersect <- function(x, y) {
    .Call(`_s2_S2Polygons_intersect`, x, y)
}

#' compute centroids for a list of s2polygons
#'
#' this function is equivalent to \link[sf]{st_centroid}, in that it
#' returns a numeric vector with polygon centroids
#' 
#' @param x List of list of loops represented by three-column matrices.
#' @aliases S2Polygons_centroid
#' @export S2Polygons_centroid
S2Polygons_centroid <- function(x) {
    .Call(`_s2_S2Polygons_centroid`, x)
}

#' compute areas for a list of s2polygons
#'
#' this function is equivalent to \link[sf]{st_area}, in that it
#' returns a numeric vector with polygon areas
#' 
#' @param x List of list of loops represented by three-column matrices.
#' @aliases S2Polygons_area
#' @details the area is on the unit sphere, in [0, 4 * pi]
#' @export S2Polygons_area
S2Polygons_area <- function(x) {
    .Call(`_s2_S2Polygons_area`, x)
}

S2Polygon_contains_point <- function(points, poly, approx = TRUE) {
    .Call(`_s2_S2Polygon_contains_point`, points, poly, approx)
}

#' Distance from points to line on sphere
#'
#' Distance from points to line on sphere.
#' 
#' @param line Line represented by a sequence of vertices given as a single
#' three-column matrices with one line per vertex.
#' @param x Points represented by three-column matrices.
#' @export S2Polyline_dist
S2Polyline_dist <- function(line, x) {
    .Call(`_s2_S2Polyline_dist`, line, x)
}

