% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-transformers.R
\name{s2_boundary}
\alias{s2_boundary}
\alias{s2_centroid}
\alias{s2_closest_point}
\alias{s2_minimum_clearance_line_between}
\alias{s2_difference}
\alias{s2_sym_difference}
\alias{s2_intersection}
\alias{s2_union}
\alias{s2_snap_to_grid}
\alias{s2_buffer_cells}
\alias{s2_centroid_agg}
\alias{s2_union_agg}
\title{S2 Geography Transformations}
\usage{
s2_boundary(x)

s2_centroid(x)

s2_closest_point(x, y)

s2_minimum_clearance_line_between(x, y)

s2_difference(x, y, options = s2_options())

s2_sym_difference(x, y, options = s2_options())

s2_intersection(x, y, options = s2_options())

s2_union(x, y = NULL, options = s2_options())

s2_snap_to_grid(x, grid_size)

s2_buffer_cells(
  x,
  distance,
  max_cells = 1000,
  min_level = -1,
  radius = s2_earth_radius_meters()
)

s2_centroid_agg(x, na.rm = FALSE)

s2_union_agg(x, options = s2_options(), na.rm = FALSE)
}
\arguments{
\item{x}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}

\item{y}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}

\item{options}{An \code{\link[=s2_options]{s2_options()}} object describing the polygon/polyline
model to use and the snap level.}

\item{grid_size}{The grid size to which coordinates should be snapped;
will be rounded to the nearest power of 10.}

\item{distance}{The distance to buffer, in units of \code{radius}.}

\item{max_cells}{The maximum number of cells to approximate a buffer.}

\item{min_level}{The minimum cell level used to approximate a buffer
(1 - 30). Setting this value too high will result in unnecessarily
large geographies, but may help improve buffers along long, narrow
regions.}

\item{radius}{Radius of the earth. Defaults to the average radius of
the earth in meters as defined by \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}}.}

\item{na.rm}{For aggregate calculations use \code{na.rm = TRUE}
to drop missing values.}
}
\description{
These functions operate on one or more geography vectors and
return a geography vector.
}
\section{Model}{

The geometry model indicates whether or not a geometry includes its boundaries.
Boundaries of line geometries are its end points.
OPEN geometries do not contain their boundary (\code{model = 0}); CLOSED
geometries (\code{model = 2}) contain their boundary; HALF-CLOSED geometries
(\code{model = 1}) contain half of their boundaries, such that when two polygons
do not overlap or two lines do not cross, no point exist that belong to
more than one of the geometries. (This latter form, half-closed, is
not present in the OpenGIS "simple feature access" (SFA) standard nor DE9-IM on
which that is based). A value of -1 does not set the model, leaving the
S2 default (HALF-CLOSED). The default values for \code{\link[=s2_contains]{s2_contains()}} (0)
and covers/covered_by (2) correspond to the SFA standard specification
of these operators.
}

\examples{
# returns the boundary:
# empty for point, endpoints of a linestring,
# perimeter of a polygon
s2_boundary("POINT (-64 45)")
s2_boundary("LINESTRING (0 0, 10 0)")
s2_boundary("POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))")

# returns the area-weighted centroid, element-wise
s2_centroid("POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))")
s2_centroid("LINESTRING (0 0, 10 0)")

# returns the unweighted centroid of the entire input
s2_centroid_agg(c("POINT (0 0)", "POINT (10 0)"))

# returns the closest point on x to y
s2_closest_point(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POINT (0 90)" # north pole!
)

# returns the shortest possible line between x and y
s2_minimum_clearance_line_between(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POINT (0 90)" # north pole!
)

# binary operations: difference, symmetric difference, intersection and union
s2_difference(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POLYGON ((5 5, 15 5, 15 15, 5 15, 5 5))",
  # 32 bit platforms may need to set snap rounding
  s2_options(snap = s2_snap_level(30))
)

s2_sym_difference(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POLYGON ((5 5, 15 5, 15 15, 5 15, 5 5))",
  # 32 bit platforms may need to set snap rounding
  s2_options(snap = s2_snap_level(30))
)

s2_intersection(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POLYGON ((5 5, 15 5, 15 15, 5 15, 5 5))",
  # 32 bit platforms may need to set snap rounding
  s2_options(snap = s2_snap_level(30))
)

s2_union(
  "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
  "POLYGON ((5 5, 15 5, 15 15, 5 15, 5 5))",
  # 32 bit platforms may need to set snap rounding
  s2_options(snap = s2_snap_level(30))
)

# use s2_union_agg() to aggregate geographies in a vector
s2_union_agg(
  c(
    "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))",
    "POLYGON ((5 5, 15 5, 15 15, 5 15, 5 5))"
  ),
  # 32 bit platforms may need to set snap rounding
  s2_options(snap = s2_snap_level(30))
)

# snap to grid rounds coordinates to a specified grid size
s2_snap_to_grid("POINT (0.333333333333 0.666666666666)", 1e-2)

}
\seealso{
BigQuery's geography function reference:
\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_boundary}{ST_BOUNDARY}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_centroid}{ST_CENTROID}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_closestpoint}{ST_CLOSESTPOINT}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_difference}{ST_DIFFERENCE}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_intersection}{ST_INTERSECTION}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_union}{ST_UNION}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_snaptogrid}{ST_SNAPTOGRID}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_simplify}{ST_SIMPLIFY}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_union_agg}{ST_UNION_AGG}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#s2_centroid_agg}{ST_CENTROID_AGG}
}
}
